$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
    
	$(".datePicker").mask("99-99-9999");
    $("#reporte_botones").hide();

    $("#slcCategoriaProducto").select2({
        placeholder: "Buscar categoría",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'registro_academico/mantenimientos/consultar_categoria',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
                return {
                    categoria: categoria
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.tia_id,
                        'text': (item.tia_codigo+' - '+item.tia_nombre)
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcCategoriaProducto").live('change', function(event) {
        categoria = $(this).val();
        if(categoria > 0) {
          
           $.ajax({
                  type: 'POST',
                  dataType: 'json',
                  url:  window.gSateliteWhite.baseUrl('facturacion/reportes/select_cursos_categoria'),
                  data: {categoria: categoria},
                  beforeSend: function(){
                    $("#slcCurso").attr("placeholder", "Cargando...");
                    $("#slcCurso").select2();
                  },
                  success: function (data) {
                    $("#slcCurso").attr("placeholder", "Seleccione");
                    $("#slcCurso").html(data);
                    $("#slcCurso").select2();
                     
                  }
              });
        }else{
          $("#slcCurso").html('<option value=""></option>')
          $("#slcCurso").attr("placeholder", "Seleccione");
          $("#slcCurso option:first").attr('selected','selected');
          $("#slcCurso").select2();
         
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        event.preventDefault();
        var fecha_inicio = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var categoria = $("#slcCategoriaProducto").val();
        var curso = $("#slcCurso").val();
        var state = $("#slcState").val();    
        $.ajax({
            url: window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_ventas_cuotas'),
            type: "post",
            dataType: 'json',
            data: {
                fecha_inicio: fecha_inicio,
                fecha_fin: fecha_fin,
                categoria: categoria,
                curso: curso,
                estado: state,
                tipo_reporte: "" 
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (obj) {
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                $("#reporte_botones").show();
                wait.close();
            }
        });
    });

    $("#imprimir_factura").live("click", function(){
        $("#frm_reporte_ventas_cuota").attr('action','imprimir_reporte_ventas_cuotas/')
        var tipo = 'excel';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var categoria = $("#slcCategoriaProducto").val();
        var curso = $("#slcCurso").val();  
        if(!$("#frm_reporte_ventas_cuota").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el período de fechas.');
               return false;
            }
        }  
        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_ventas_cuota").submit();
  
      })
  
      $("#imprimir_factura_pdf").live("click", function(){
        $("#frm_reporte_ventas_cuota").attr('action','imprimir_reporte_ventas_cuotas/')
        var tipo = 'pdf';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var categoria = $("#slcCategoriaProducto").val();
        var curso = $("#slcCurso").val();
  
        if(!$("#frm_reporte_ventas_cuota").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el período de fechas.');
               return false;
            }
        }
  
        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_ventas_cuota").submit();
      })

    $("#frm_reporte_ventas_cuota").validate({
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}