$(document).ready(function () {

    var pathArray = window.location.pathname.split( '/' );
    var urlj=url_base_proyecto;    

    // Array de Meses
    var meses = {'Enero': 1, 'Febrero': 2, 'Marzo': 3, 'Abril': 4, 'Mayo': 5, 'Junio': 6, 'Julio': 7, 'Agosto': 8, 'Septiembre': 9, 'Octubre': 10,  'Noviembre': 11, 'Diciembre': 12};

    $(".datePicker").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'MM-yy',
        onClose: function(dateText, inst) { 
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    // Ocultar el calendario para solo mostrar el mes
    $(".datePicker").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });    

    $('select').select2();  

    $("#btn_consultar").click(function () {
        event.preventDefault();    
        var txtfecha_mensual  = $("#txtfecha_mensual").val();
        var txtperiodo_hidden = $("#txtperiodo_hidden").val();
        var slc_vendedor      = ($("#slc_vendedor").val() > 0)?$("#slc_vendedor").val():'';
        var slc_sucursal      = ($("#slc_sucursal").val() > 0)?$("#slc_sucursal").val():'';
        var grafico_vendedor  = (slc_vendedor != '') ? slc_vendedor : 0;
        var grafico_sucursal  = (slc_sucursal != '') ? slc_sucursal : 0;    
        var respuesta         = false;
        if ($.trim(txtfecha_mensual) == '') {
            $('#txtfecha_mensual_error').text('Campo Requerido');
            return false;
        }
        $.ajax({
            url: window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_vendedores'),
            data: {
                txtfecha_mensual: txtfecha_mensual,
                txtperiodo_hidden: txtperiodo_hidden,
                slc_vendedor: slc_vendedor,
                slc_sucursal: slc_sucursal,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                var dir = '<a class="btn btn-info iconic-icon-bars white" id="ver_grafica" target="_blank"';
                dir += 'href="'+urlj+'facturacion/reportes/ver_grafico_reporte_vendedores/'+txtfecha_mensual+'/'+grafico_vendedor+'/'+grafico_sucursal+'"></a>';
                link = $("#link").html(dir);
                wait.close();
            }
        });
    });

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txtfecha_mensual  = $("#txtfecha_mensual").val();
            var txtperiodo_hidden = $("#txtperiodo_hidden").val();
            var slc_vendedor      = ($("#slc_vendedor").val() > 0)?$("#slc_vendedor").val():'';
            var slc_sucursal      = ($("#slc_sucursal").val() > 0)?$("#slc_sucursal").val():'';
        
            var respuesta = false;

            if ($.trim(txtfecha_mensual) == '') {
                $('#txtfecha_mensual_error').text('Campo Requerido');
                return false;
            }
    
            form.submit();
        }
    });

    $("body").on("change", "#txtfecha_mensual", function(e) {
        var txtfecha_mensual  = $(this).val();
        // Obtener la fecha
        var mes_split = txtfecha_mensual.split('-'); 
        var fecha = mes_split;
        $("#txtperiodo_hidden").val(fecha[1]+'-'+meses[fecha[0]]);
        // console.log(fecha[1]+'-'+meses[fecha[0]]);
    });

    $("#ver_grafica").fancybox({
       'width' : '1200',
       'height' : '800',
       'autoScale' : true,
       'transitionIn' : 'none',
       'transitionOut' : 'none',
       'type' : 'iframe',
       'openEffect' : 'elastic',
       'closeEffect' : 'elastic'
    });
});