$(document).ready(function () {

    $("#slcSucursal, #slcCajero").select2();

    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".txtFechas").mask('99-99-9999');

    $("body").on("click", "#btn_consultar", function () {
        event.preventDefault();

        var txt_fecha_inicio    = $("#txt_fecha_inicio").val();
        var txt_fecha_fin       = $("#txt_fecha_fin").val();
        var slcSucursal         = $("#slcSucursal").val();
        var slcCajero           = $("#slcCajero").val();
        var error_text          = "Campo requerido";
        var error               = false;

        if ( txt_fecha_inicio == "" ){
            $("#txt_fecha_inicio_error").html(error_text);
            error   = true;
        }

        if ( txt_fecha_fin == "" ){
            $("#txt_fecha_fin_error").html(error_text);
            error   = true;
        }

        if (!validarPeriodo(txt_fecha_inicio, txt_fecha_fin)) {
            crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
            return false;
        }

        if ( error == true ) {
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            return false;
        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_comprobantes'),
            data: {
                slcCajero: slcCajero,
                slcSucursal: slcSucursal,
                txt_fecha_inicio: txt_fecha_inicio,
                txt_fecha_fin: txt_fecha_fin
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor_reportes").html(obj.html);
                // $("#tbl_contenedor").dataTable().fnDestroy();
                $("#dv_contenedor_reportes").show("slide", {
                    direction: 'left'
                }, 500);
                aplicar_datatable("#tbl_contenedor");
                wait.close();
            }
        });

    });

    $("#frm_reporte").validate({
        ignore: [],
        rules: {
            txt_fecha_inicio: {required: true},
            txt_fecha_fin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txt_fecha_inicio    = $("#txt_fecha_inicio").val();
            var txt_fecha_fin       = $("#txt_fecha_fin").val();
            var error               = false;

            if (!validarPeriodo(txt_fecha_inicio, txt_fecha_fin)) {
                crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
                return false;
            }
    
            if ( error == true ) {
                crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
                return false;
            }        

            form.submit();
        }
    });

});
function aplicar_datatable(id){
    $(id).dataTable({
        //"sPaginationType": "full_numbers",
        "bFilter": true,
        "bJQueryUI": false,
        "bAutoWidth": true,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}