var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

$(document).ready(function() {
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#producto").numeric();
    $("select").select2({placeholder : 'Seleccione'});

    $("#btn_consultar").click(function () {
        event.preventDefault();
        var txtFechaIni = $("#txtFechaIni").val();
        var txtFechaFin = $("#txtFechaFin").val();
        var producto    = $("#producto").val();
        var categoria   = $("#slcCategoria").val();
        var marcap      = $("#slcMarca").val();
        // var respuesta       = false;
        if ( txtFechaIni == "" || txtFechaFin == "") {
            crear_alerta('error', 'Reporte de Precios de Ventas', 'Por favor ingrese el rango de fechas.');
            $("#txtFechaIni").val("");
            return false;
        }
        if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
            crear_alerta('error', 'Reporte de Precios de Ventas', 'Verifique el período de fechas.');
            return false;
        }
        wait.start();
        $.ajax({
            url: urlj+'facturacion/reportes/rpt_productos_masvendidos',
            dataType:'json',
            type: 'POST',
            data: {
                txtFechaIni: txtFechaIni,
                txtFechaFin: txtFechaFin,
                producto:    producto, 
                categoria:   categoria,
                marca: marcap,
                tipo_reporte: "grid"
            },
            success:function(data) {
                $("#dv_contenedor").html(data.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });


    });

    $("#frm_reporte").validate({
        rules: {
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txtFechaIni         = $("#txtFechaIni").val();
            var txtFechaFin         = $("#txtFechaFin").val();
            var respuesta = false;
            if ( txtFechaIni == "" || txtFechaFin == "") {
                crear_alerta('error', 'Reporte de Precios de Compras', 'Por favor ingrese el rango de fechas.');
                $("#txtFechaIni").val("");
                $("#slc_estado").val("");
                return false;
            }
            if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
                crear_alerta('error', 'Reporte de Precios de Compras', 'Verifique el período de fechas.');
                return false;
            }
            form.submit();
        }
    });
});
