jQuery(document).ready(function ($) {
    $('select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  
        validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); }
    );

    $("#slcSucursales").select2({
        placeholder:'Buscar Cliente',
        minimumInputLength: 3,
        ajax: {
            url:urlj + 'cotizaciones/cotizaciones/get_clientes',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    
    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
           $("#contenedorTabla").hide("slide", {
            direction: 'right'
          }, 400, function() { //despues de ocultar div enviar el ajax
            $.ajax({
                    url: window.satelite.base_url('facturacion/reportes/notasrem_nofact/1'),
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        txtFecha_desde: $("#txtFecha_desde").val(),
                        txtFecha_hasta: $("#txtFecha_hasta").val(),
                        slcSucursales:  $("#slcSucursales").val()
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    error: function (xhr, status, error){
                        console.log(xhr.responseText);
                        exportarError(xhr.responseText);
                        wait.close();
                    },
                    success: function (json) {
                        console.log(json);
                        //$("#contenedorTabla").html(text);
                        $("#contenedorTabla").html(json.html);
                        $("#contenedorTabla").show("slide", {
                          direction: 'left'
                        }, 500);
                        wait.close();
                    }
                });
        });
       }
   });
});

function getnow(){ 
    let date = new Date().toISOString().slice(0, 10);
    let time = new Date();
    let hours = time.getHours();
    let minutes = time.getMinutes();
    let seconds = time.getSeconds();
    return date + ' ' + hours + ':' + minutes + ':' + seconds;
}

$("#exportar_pdf").click(function(){
    let url = window.satelite.base_url('facturacion/reportes/notasrem_nofact/2');
    let params = {};
    params.tipoFactura = $('#tif_id').val();
    params.sucursal = $("#slcSucursales").val();
    params.fecha_desde = $("#txtFecha_desde").val();
    params.fecha_hasta = $("#txtFecha_hasta").val();
    downloadFile(url, params, `Notas de remisión no facturadas - ${getnow()}.pdf`);

});
$("#exportar_excel").click(function(){
    let url = window.satelite.base_url('facturacion/reportes/notasrem_nofact/3');
    let params = {};
    params.tipoFactura = $('#tif_id').val();
    params.sucursal = $("#slcSucursales").val();
    params.fecha_desde = $("#txtFecha_desde").val();
    params.fecha_hasta = $("#txtFecha_hasta").val();
    downloadFile(url, params, `Notas de remisión no facturadas - ${getnow()}.xls`);
});

function downloadFile(url, params, filename) {
    fetch(url, {
        method: 'post',
        body: JSON.stringify(params)
        }).then((res) => { 
            return res.blob(); 
        }).then((data) => {
            let a = document.createElement("a");
            a.href = window.URL.createObjectURL(data);
            a.download = filename;
            a.click();
        }
    );
}


