jQuery(document).ready(function ($) {
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({
            dateFormat: 'mm-yy', 
            changeMonth: true, 
            changeYear: true,
            showButtonPanel: true,
        onClose: function(dateText, inst) { 
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta');
        }
    });

    $("#chkConsolidar").iButton({
        'labelOn': 'Día',
        'labelOff': 'Individual'
    });

    $("#ventas_filtro, #slcTipoFac").select2();

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) { 
        validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta');
    });

    $("#ventas_filtro").change(function() {
        if ($(this).val() == 1) {
            $("#chkConsolidar").iButton("toggle", true);
        }
    });
    

    var url_ajax = window.satelite.base_url('facturacion/reportes/filtrar_informe_icv');
    $("#frmConsultaform").attr('target', '_blank');
    $("#frmConsultaform").attr('action', url_ajax);

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            ventas_filtro: {required: true, min: 1},
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true}
        },
        messages: {
            ventas_filtro: "Campo requerido",
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");

        },
        submitHandler: function (form) {            
            if ($("#tipo_accion").val() == 0 ) {
                $("#contenedorTabla").hide("slide", { 
                    direction: 'right'
                }, 400, function() { //despues de ocultar div enviar el ajax
                    $.ajax({
                        url: url_ajax,
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            ventas_filtro: $("#ventas_filtro").val(),
                            txtFecha_desde: $("#txtFecha_desde").val(),
                            txtFecha_hasta: $("#txtFecha_hasta").val(),
                            slcTipoFac: $("#slcTipoFac").val(),
                            chkConsolidar: ($("#chkConsolidar").attr('checked')) ? 1 : 0
                        }, beforeSend: function () {
                            wait.start();
                        }, error: function (xhr, status, error){
                            exportarError(xhr.responseText);
                            wait.close();
                        }, success: function (json) {
                            $("#contenedorTabla").html(json.html);
                            $("#contenedorTabla").show("slide", {
                                direction: 'left'
                            }, 500);
                            wait.close();
                        }
                    });
                });
            } else {
                form.submit();
            }
        }
    });

});