$(document).ready(function () {
	
	$("#slcCaja").select2({placeholder: "Seleccione"});


	$(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
	$(".datePicker").mask("99-99-9999");

	$("#btn_consultar").click(function () {
		event.preventDefault();
		$("#excel").css("display", "none");
		$("#pdf").css("display", "none");

		var txtFechaIni = $("#txtFechaIni").val();
		var txtFechaFin = $("#txtFechaFin").val();
		var caja    	= $("#slcCaja").val();
		var caja_text 	= $("#slcCaja option:selected").text(); 

		if ( txtFechaIni == "" || txtFechaFin == "") {
			crear_alerta('error', 'Rep. de Análisis de Cotizaciones', 'Por favor ingrese el rango de fechas.');
			return false;
		}
		if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
			crear_alerta('error', 'Rep. de Análisis de Cotizaciones', 'Verifique el período de fechas.');
			return false;
		}

		$("#h_fecha_ini").val(txtFechaIni);
		$("#h_fecha_fin").val(txtFechaFin);
		$("#h_caja_id").val(caja);
		$("#h_caja_text").val(caja_text);

		$.ajax({
			dataType: 'text',
			type: 'POST',
			url: urlj+'facturacion/reportes/corte_caja/1',
			data: {
				txtFechaIni: 	txtFechaIni,
				txtFechaFin: 	txtFechaFin,
				tipo_reporte: 	"",
				caja:			caja
			},
			beforeSend: function () {
				wait.start();
			},
			success:function(data) {
				$("#dv_contenedor").html(data);
				if(data.trim()!=''){
					$("#excel").css("display", "");
					$("#pdf").css("display", "");
				}
				wait.close();
			}
		});
	});

});