$(document).ready(function(){
    $('select').select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#reporte").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){

            if ( !validarPeriodo($("#txtFechaIni").val(), $("#txtFechaIni").val()) ) {
                crear_alerta('error', 'Reporte de anticipos por estado', 'Verifique el período de fechas.');
                return false;
            }

            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val( $("#txtFechaFin").val());
            form.submit();
        }
    });

    $("#reporte").validate({
        rules: {
           
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){

            var fecha_ini = $("#txtFechaIni").val();
            var fecha_fin = $("#txtFechaFin").val();

            if (fecha_ini == '' || fecha_fin == '') {
                crear_alerta('error', 'Reporte de anticipos por estado', 'Fechas son obligatorias.');
                return false;
            }

            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Reporte de anticipos por estado', 'Verifique el período de fechas.');
                return false;
            }

            var cliente 		= $("#slc_cliente").val();
            var nombre_cliente  = $("#slc_cliente  option:selected").text() ;

            var estado          = $("#slc_estado").val();
            var nombre_estado   = $("#slc_estado  option:selected").text() ;

            $("#filtro_inicio").val(fecha_ini);
            $("#filtro_fin").val(fecha_fin);
            $("#filtro_cliente").val(cliente);
            $("#filtro_estado").val(estado);
            $("#filtro_cliente_nombre").val(nombre_cliente);
            $("#filtro_estado_nombre").val(nombre_estado);

            form.submit();
        }


    });


    $("#btnConsultar").click(function(){
        event.preventDefault();

        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Reporte de anticipos por estado', 'Fechas son obligatorias.');
            return false;
        }

        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('error', 'Reporte de anticipos por estado', 'Verifique el período de fechas.');
            return false;
        }

        var cliente 		= $("#slc_cliente").val();
        var nombre_cliente  = $("#slc_cliente  option:selected").text() ;

        var estado          = $("#slc_estado").val();
        var nombre_estado   = $("#slc_estado  option:selected").text() ;

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_anticiposxestado/1'),
                        data: {cliente: cliente,nombre_cliente:nombre_cliente,
                                estado:estado,nombre_estado:nombre_estado,
                                fecha_ini:fecha_ini,fecha_fin:fecha_fin},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                           
                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy(); 

                            $("#tbContenedorListado").html(result);
                         
                            aplicarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                            $("#filtro_inicio").val(fecha_ini);
                            $("#filtro_fin").val(fecha_fin);
                            $("#filtro_cliente").val(cliente);
                            $("#filtro_estado").val(estado);
                            $("#filtro_cliente_nombre").val(nombre_cliente);
                            $("#filtro_estado_nombre").val(nombre_estado);
                        }
                    });
                }
        );

    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}