$(document).ready(function () {
    $("select").select2({placeholder: 'Seleccione'});
    $('select option[value=0]').val('');   

    $("#chkInfo").iButton({    
        'labelOn':  ' Cliente  ',
        'labelOff': '  Vendedor ',
        'resizeHandle': false,
        'resizeContainer': true,
        change: function (element) {
            if (element.is(':checked')) {
                $("#txt_info").val(1);
            } else {
                $("#txt_info").val(0);
            }
        }
    });

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    $("#form_reporte_personal_factura").validate({
        ignore:"",
        rules: {
            //txtFechaIni:{ required:true},
            txtFechaFin:{ required:true},
            slcCategoria:{ required:true,min:1}
            //slcVendedor:{ required:true,min:1},
            //slcPago:{ required:true,min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#imprimir_factura").live("click", function(){
        $("#form_reporte_personal_factura").attr('action','imprimir_reporte_producto_facturacion/')
        var tipo = 'excel';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if(!$("#form_reporte_personal_factura").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }
        $("#tipo_reporte").val(tipo);
        $("#form_reporte_personal_factura").submit();
    });

    $("#imprimir_factura_pdf").live("click", function(){
        $("#form_reporte_personal_factura").attr('action','imprimir_reporte_producto_facturacion/')
        var tipo = 'pdf';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if(!$("#form_reporte_personal_factura").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }
        $("#tipo_reporte").val(tipo);
        $("#form_reporte_personal_factura").submit();
    });

    $("#txtFechaIni,#txtFechaFin").change(function(event) {  validar_fecha_inicio_fin('txtFechaIni','txtFechaFin','La fecha de desde debe ser menor a la fecha hasta'); });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var productos = $("#slcproducto_servicio").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var bodega = $("#slc_bod").val();
        
        if (fecha_ini == "" || fecha_fin == "" ){
            crear_alerta('error','Alerta','Fechas son obligatorias.');
            return false;
        }
        $("#dv_contenedor_reg").hide('slide',{ direction:'right' }, 400,function(){
            $.ajax({
                type:'post',
                url:window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_productos_facturacion/1'),
                data:{
                    productos:productos,
                    fecha_ini:fecha_ini,
                    fecha_fin:fecha_fin,
                    bodega:bodega,
                    chkInfo: ($("#chkInfo").attr('checked'))? 1:0 
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(result){
                    $('#encabezado').show();
                    $("#datagried").html(result);
                    $("#control").show();
                    $("#imprimir_factura").show();
                    $("#imprimir_factura_pdf").show();
                    wait.close();
                    $("#dv_contenedor_reg").show("slide", { direction: 'left' }, 500);
                }
            });
        });
    });

    $("#slcproducto_servicio").select2({
        placeholder:'Buscar productos',
        minimumInputLength: 3,
        multiple:true,
        ajax: {
            url:urlj+'modulo_compras/procesos/consultar_articulos',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (articulo) {
                return {
                    articulo: articulo
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.art_id,
                        'text': (item.art_codigo+' - '+item.art_nombre)
                    });
                });
                return {
                    results: myResults
                };
            } 
        }
    });  

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}