$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    $("#slcEstado").select2();

    $("#form_reporte_personal_factura").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
            //slcEstado:{ required:true,min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#imprimir_factura").live("click", function(){

      $("#form_reporte_personal_factura").attr('action','imprimir_personal_factura/')
      var estado = $("#slcEstado").val();
      var tipo = 'excel';
      var estado_join = '';
      var nuevo_label = "";
      $("#puestos_personal").val(estado);
      var fecha_ini = $("#txtFechaIni").val();
      var fecha_fin = $("#txtFechaFin").val();
      if(!$("#form_reporte_personal_factura").valid()){
        crear_alerta('error','Alerta','Campos con * son requeridos.');
        return false;
      }
      if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
             crear_alerta('error','Alerta','Verifique el periodo de fechas.');
             return false;
          }
      }

      if(estado != null){
          for(var x = 0; x < estado.length; x++){
              if((x+1) == estado.length){
                  nuevo_label += $("#slcEstado option[value="+estado[x]+"]").text();
              } else{
                  nuevo_label += $("#slcEstado option[value="+estado[x]+"]").text() + ',';
              }
          }
          estado_join = estado.join('-');
      }
      $("#label_select_reporte").val(nuevo_label);
      $("#tipo_reporte").val(tipo);
      $("#form_reporte_personal_factura").submit();

    })

    $("#imprimir_factura_pdf").live("click", function(){
      $("#form_reporte_personal_factura").attr('action','imprimir_personal_factura/')
      var estado = $("#slcEstado").val();
      var tipo = 'pdf';
      var estado_join = '';
      var nuevo_label = "";
      $("#puestos_personal").val(estado);
      var fecha_ini = $("#txtFechaIni").val();
      var fecha_fin = $("#txtFechaFin").val();
      if(!$("#form_reporte_personal_factura").valid()){
        crear_alerta('error','Alerta','Campos con * son requeridos.');
        return false;
      }
      if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
             crear_alerta('error','Alerta','Verifique el periodo de fechas.');
             return false;
          }
      }

      if(estado != null){
          for(var x = 0; x < estado.length; x++){
              if((x+1) == estado.length){
                  nuevo_label += $("#slcEstado option[value="+estado[x]+"]").text();
              } else{
                  nuevo_label += $("#slcEstado option[value="+estado[x]+"]").text() + ',';
              }
          }
          estado_join = estado.join('-');
      }
      $("#label_select_reporte").val(nuevo_label);
      $("#tipo_reporte").val(tipo);
      $("#form_reporte_personal_factura").submit();
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var estado = $("#slcEstado").val();

        var nuevo_label = "";
        if(estado != null){
            for(var x = 0; x < estado.length; x++){
                if((x+1) == estado.length){
                    nuevo_label += $("#slcEstado option[value="+estado[x]+"]").text();
                } else{
                    nuevo_label += $("#slcEstado option[value="+estado[x]+"]").text() + ',';
                }
            }
        }

        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if(!$("#form_reporte_personal_factura").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el periodo de fechas.');
               return false;
            }
        }
        if($.trim(estado) == ""){
          estado = -1;
        }

        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_personal_factura/1'),
                   data:{estado:estado,fecha_ini:fecha_ini,fecha_fin:fecha_fin,'label':nuevo_label},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       $('#encabezado').show();
                        $("#datagried").html(result);
                        $("#control").show();
                        $("#imprimir_factura").show();
                        $("#imprimir_factura_pdf").show();
                        wait.close();
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

   });
   
   
   $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#txtFechaFin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}