$(document).ready(function(){
  
  $("select option[value='0']").val('');
  $("input[name^='fecha']").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true, 
    changeYear: true,
    showButtonPanel: true,
    changeMonth: true,
    changeYear: true,
    dateFormat: 'dd-mm-yy',
    monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
    dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
    nextText: "Siguiente",
    prevText: "Anterior"});
  $("input[name^='fecha']").mask("99-99-9999");
  $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
  
  $("#tipo_fac").select2();

  $("#filtro").click(function(){

    var tipo = $("#tipo_fac").val();
    var fecha_ini = $("#fecha_inicio").val();
    var fecha_fin = $("#fecha_fin").val();

    if(fecha_ini!='' && fecha_fin!=''){
        if(!verifica_fecha(fecha_ini,fecha_fin)){
          return false; 
        }
    }
    if($("#tipo_fac").val()>0 && $("#fecha_inicio").val()!= '' && $("#fecha_fin").val()!= ''){
    $.ajax({
      url: 'consultar_libros_iva',
      type: 'POST',
      dataType: 'json',
      data: {tipo:  tipo,fecha_ini:fecha_ini,fecha_fin:fecha_fin},

      success:function(data) {
        filas=data.drop+data.total;
        $("#datagried").html(filas);
        $("#checkAll").show('slide');
        $("#descargar").show();
        $(".form-actions").show('slow');
        $(".botones_export_print").show('slow');
      }
    });
    }else if ($("#tipo_fac").val()<=0 && $("#fecha_inicio").val()<=0 && $("#fecha_fin").val()<=0) {
            $("#tipo_fac_error").text('Campo requerido');
            $("#fecha_ini_error").text('Campo requerido');
            $("#fecha_fin_error").text('Campo requerido');
        } 
        if ($("#tipo_fac").val()<=0) {
          $("#tipo_fac_error").text('Campo requerido');
        }
        if ($("#fecha_inicio").val()<=0) {
           $("#fecha_ini_error").text('Campo requerido');
        }
        if ($("#fecha_fin").val()<=0) {
          $("#fecha_fin_error").text('Campo requerido');
        }
  });

  $("#fecha_inicio").focus(function(event){
      $("#fecha_inicio").removeClass('error');
      $("#fecha_ini_error").text('');
  });

 $("#fecha_fin").focus(function(event){
      $("#fecha_fin").removeClass('error');
      $("#fecha_fin_error").text('');
  });

 $("#tipo_fac").change(function(event){
      $("#tipo_fac").removeClass('error');
      $("#tipo_fac_error").text('');
  });


  function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        // var f1 = new Date(fecha_i);
        // var f2 = new Date(fecha_f);

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          crear_alerta('error','Error','Verifique las fechas del período');
          //$("#fecha_fin_error").text("Verifique las fechas del período");
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin_error").text('');
          return true;
        }
    }
});