$(document).ready(function () {
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $("select").select2();
    $(".datePicker").mask("99-99-9999");

    $("#form_reporte_personal_factura").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#imprimir_factura").live("click", function(){
        $("#form_reporte_personal_factura").attr('action','imprimir_reporte_facturas_detallado/')
        var tipo = 'excel';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if(!$("#form_reporte_personal_factura").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el periodo de fechas.');
                return false;
            }
        }
        $("#tipo_reporte").val(tipo);
        $("#form_reporte_personal_factura").submit();
    });

    
    $("#imprimir_factura_pdf").live("click", function(){
        $("#form_reporte_personal_factura").attr('action','imprimir_reporte_facturas_detallado/')
        var tipo = 'pdf';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if(!$("#form_reporte_personal_factura").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el periodo de fechas.');
                return false;
            }
        }
        $("#tipo_reporte").val(tipo);
        $("#form_reporte_personal_factura").submit();
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(event){
        event.preventDefault();
        var cajero    = $("#slcCaja").val();
        var documento = $("#slcDocumento").val();
        var tipo_pago = $("#slcTipoPago").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var estado    = $("#slc_estado").val();
        var vendedor  = $("#slcVendedor").val();
        if(!$("#form_reporte_personal_factura").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el periodo de fechas.');
               return false;
            }
        }
        $("#dv_contenedor_reg").hide('slide',{
            direction:'right'
        }, 400,function(){
            $.ajax({
                type:'post',
                url:window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_facturas_detallado/1'),
                data:{
                    documento:documento,
                    tipo_pago:tipo_pago,
                    fecha_ini:fecha_ini,
                    fecha_fin:fecha_fin,
                    estado:estado,
                    vendedor:vendedor,
                    cajero:cajero
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(result){
                    $('#encabezado').show();
                    $("#datagried").html(result);
                    $("#control").show();
                    $("#imprimir_factura").show();
                    $("#imprimir_factura_pdf").show();
                    wait.close();
                    $("#dv_contenedor_reg").show("slide", {
                        direction: 'left'
                    }, 500);
                }
            });
        });
    });
   
    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    } else {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}