$(document).ready(function(){
  
  $("select option[value='0']").val('');
  $("input[name^='fecha']").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true, 
    changeYear: true,
    showButtonPanel: true,
    changeMonth: true,
    changeYear: true,
    dateFormat: 'dd-mm-yy',
    monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
    dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
    nextText: "Siguiente",
    prevText: "Anterior"});
  $("input[name^='fecha']").mask("99-99-9999");
  $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
  
  $("#cliente").select2();
         
  $("#filtro").click(function(){

    var cliente = $("#cliente").val();
    var fecha_ini = $("#fecha_inicio").val();
    var fecha_fin = $("#fecha_fin").val();
   /* if(cliente == ''){
      crear_alerta('error','Error','Debe seleccionar un cliente');
      return false();
    }*/
    if(fecha_ini!='' && fecha_fin!=''){
      if(!verifica_fecha(fecha_ini,fecha_fin)){
        return false; 
      }
    }
    if($("#fecha_inicio").val()!='' && $("#fecha_fin").val()!= '' &&  $("#cliente").val()>0){
    $.ajax({
      url: 'consultar_contabilidad',
      type: 'POST',
      dataType: 'json',
      data: {cliente:  cliente,fecha_ini:fecha_ini,fecha_fin:fecha_fin},
      success:function(data) {
        $("#contenido").html(data.drop);
        $("#checkAll").show('slide');
        $("#descargar").show();
        $(".form-actions").show('slow');
        $(".botones_export_print").show('slow');
      }
    });
    }else if ($("#fecha_inicio").val()<=0 && $("#fecha_fin").val()<=0 &&  $("#cliente").val()<=0) {
            $("#fecha_inicio_error").text('Campo requerido');
            $("#fecha_fin_error").text('Campo requerido');
            $("#cliente_error").text('Campo requerido');
        }
        if ($("#cliente").val()<=0) {
             $("#cliente_error").text('Campo requerido');
           }
        if ($("#fecha_fin").val()<=0) {
          $("#fecha_fin_error").text('Campo requerido');
        }
        if ($("#fecha_inicio").val()<=0) {
          $("#fecha_inicio_error").text('Campo requerido');
        }
  });

  $("#fecha_inicio").focus(function(event){
      $("#fecha_inicio").removeClass('error');
      $("#fecha_inicio_error").text('');
  });

 $("#fecha_fin").focus(function(event){
      $("#fecha_fin").removeClass('error');
      $("#fecha_fin_error").text('');
  });

 $("#cliente").change(function(event){
      $("#cliente").removeClass('error');
      $("#cliente_error").text('');
  });

  function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        // var f1 = new Date(fecha_i);
        // var f2 = new Date(fecha_f);
        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          crear_alerta('error','Error','Verifique las fechas del período');
          //$("#fecha_fin_error").text("Verifique las fechas del período");
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin_error").text('');
          return true;
        }
    }
});