$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#form_reporte_personal_factura").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true},
            slcCaja:{ required:true,min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#imprimir_factura").live("click", function(){
      $("#form_reporte_personal_factura").attr('action','imprimir_reporte_beneficios/')
      var tipo = 'excel';
      $("#tipo_reporte").val(tipo);
      $("#form_reporte_personal_factura").submit();

    })

    $("#imprimir_factura_pdf").live("click", function(){
      $("#form_reporte_personal_factura").attr('action','imprimir_reporte_beneficios/')
        var tipo = 'pdf';
        $("#tipo_reporte").val(tipo);
        $("#form_reporte_personal_factura").submit();
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var caja = $("#slcCaja").val();
        var txtcaja = $("#slcCaja option:selected").text();
        $("#txtCaja").val(txtcaja);
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        var slcBeneficios = $("#slcBeneficios").val();

        if(!$("#form_reporte_personal_factura").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          verifica_fecha(fecha_ini,fecha_fin);
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el rango de fechas.');
               return false;
            }
        }

        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                    type:'post',
                    url:window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_beneficios/1'),
                    data:{caja:caja,txtcaja:txtcaja,fecha_ini:fecha_ini,fecha_fin:fecha_fin, slcBeneficios: slcBeneficios},
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(result){
                        $("#rpt_txtFechaIni").val(fecha_ini);
                        $("#rpt_txtFechaFin").val(fecha_fin);
                        $("#rpt_slcCaja").val(caja);
                        $("#rpt_txtCaja").val(txtcaja);
                        $("#rpt_slcBeneficios").val(slcBeneficios);

                        $('#encabezado').show();
                        $("#datagried").html(result);
                        $("#control").show();
                        $("#imprimir_factura").show();
                        $("#imprimir_factura_pdf").show();
                        wait.close();
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

   });
   
   $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}