$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    $("#slcEstado").select2();

    $("#form_reporte_personal_factura").validate({
        ignore:"",
        rules: {
            //txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
            //slcCategoria:{ required:true,min:1}
            //slcVendedor:{ required:true,min:1},
            //slcPago:{ required:true,min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#imprimir_factura").live("click", function(){
      $("#form_reporte_personal_factura").attr('action','imprimir_reporte_acumulado_factura_mensual_categoria/')
      var tipo = 'excel';
      var fecha_fin = $("#txtFechaFin").val();
      var arreglo_fecha = fecha_fin.split("-");
      var fecha_ini = '01-'+arreglo_fecha[1]+'-'+arreglo_fecha[2];

      $("#txtFechaIni").val(fecha_ini);

      $("#txtCategoria").val($("#slcCategoria option:selected").text());

      if(!$("#form_reporte_personal_factura").valid()){
        crear_alerta('error','Alerta','Campos con * son requeridos.');
        return false;
      }
      if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
             crear_alerta('error','Alerta','No es posible filtrar para el día 1 del mes.');
             return false;
          }
      }

      $("#tipo_reporte").val(tipo);
      $("#form_reporte_personal_factura").submit();

    })

    $("#imprimir_factura_pdf").live("click", function(){
      $("#form_reporte_personal_factura").attr('action','imprimir_reporte_acumulado_factura_mensual_categoria/')
      var tipo = 'pdf';
      //var fecha_ini = $("#txtFechaIni").val();
      var fecha_fin = $("#txtFechaFin").val();

      var arreglo_fecha = fecha_fin.split("-");
      var fecha_ini = '01-'+arreglo_fecha[1]+'-'+arreglo_fecha[2];

      $("#txtFechaIni").val(fecha_ini);

      $("#txtCategoria").val($("#slcCategoria option:selected").text());

      if(!$("#form_reporte_personal_factura").valid()){
        crear_alerta('error','Alerta','Campos con * son requeridos.');
        return false;
      }
      if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
             crear_alerta('error','Alerta','No es posible filtrar para el día 1 del mes.');
             return false;
          }
      }

      $("#tipo_reporte").val(tipo);
      $("#form_reporte_personal_factura").submit();
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var categoria = $("#slcCategoria").val();

        var fecha_fin = $("#txtFechaFin").val();
        var arreglo_fecha = fecha_fin.split("-");
        var fecha_ini = '01-'+arreglo_fecha[1]+'-'+arreglo_fecha[2];
        var fecha_ini2 = '02-'+arreglo_fecha[1]+'-'+arreglo_fecha[2];
        
        console.log(fecha_ini);
        console.log(fecha_fin);

        if(!$("#form_reporte_personal_factura").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','No es posible filtrar para el día 1 del mes.');
               return false;
            }
        }

        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('facturacion/reportes/reporte_acumulado_factura_mensual_categoria/1'),
                   data:{categoria:categoria,fecha_ini:fecha_ini,fecha_ini2:fecha_ini2,fecha_fin:fecha_fin},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       $('#encabezado').show();
                        $("#datagried").html(result);
                        $("#control").show();
                        $("#imprimir_factura").show();
                        $("#imprimir_factura_pdf").show();
                        wait.close();
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

   });
   
   
   $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}