jQuery(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');
    $('select').select2();

    // Array de Meses
    var meses = {'Enero': 1, 'Febrero': 2, 'Marzo': 3, 'Abril': 4, 'Mayo': 5, 'Junio': 6, 'Julio': 7, 'Agosto': 8, 'Septiembre': 9, 'Octubre': 10,  'Noviembre': 11, 'Diciembre': 12};    

    $(".datePicker").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'MM-yy',
        onClose: function(dateText, inst) { 
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    $(".datepicker").mask("mm-yyyy");

    // Ocultar el calendario para solo mostrar el mes
    $(".datePicker").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });    

    $("#ver_detalle").click(function (event){
        var periodo = $("#periodo").val();
        var caja = $("#slcCaja").val();
        var sucursal = $("#slcSucu").val();
        var count_cajas = caja !== null ? $("#slcCaja").val().length : 0;
      
        if( ($.trim(periodo) != "") && sucursal > 0){
            consultarAjax(periodo, caja, sucursal);
        }else{
            crear_alerta('error','Error', 'Debe seleccionar la información a filtrar');
        }
    }); // Fin if consultar_datos

    $("#excel_en").click(function(event){
        event.preventDefault();
        tipo=$(this).attr('value');
        $("#tipo_reporte").val(tipo)
        $("#excel").trigger('click');
    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
        event.preventDefault();
        if($("#exportar").val()==1){
        // console.log($(this).val());
            $("#frm-report").submit();
        }else{
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }
    });

}); // End jQuery

function consultarAjax(periodo=null, caja=null, sucursal=null) {
    wait.start();
    
    $("#contenedor_consulta").hide("slide", {
        direction: 'right'
    }, 400, function () { // Después de ocultar div enviar el ajax

    // if(inicio!='' && fin!=''){
    //     if(!verifica_fecha(inicio,fin)){  
    //     wait.close();    
    //         return false; 
    //     }
    // }

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'facturacion/reportes/proyeccion_venta',
            data: {periodo:periodo, caja: caja, sucursal: sucursal},
            success: function (data) {
                $("#contenedor_consulta").html(data.resultado);
                wait.close();
                $("#ver_detalle").removeAttr('disabled');
                $("#exportar").val(1);

                $("#filtro_periodo").val(data.periodo);
                $("#filtro_caja").val(data.caja);
                $("#filtro_sucu").val(data.sucursal);

                $("#contenedor_consulta, #cajas").show("slide", {
                    direction: 'left'
                }, 500);
            },
            error: function (xhr, status, error) {
                wait.close();
                // console.log(xhr);
                // console.log(status);
                // console.log(error);
                // crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });
}

function verifica_fecha(fecha_ini, fecha_fin){
    //Se convierte la fecha a Y-m-d
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
    
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
      crear_alerta('error','Error','Verifique las fechas del período');
      return false;
    }

    if(Date.parse(fecha_i) < Date.parse(fecha_f)){
      $("#fecha_fin_error").text('');
      return true;
    }
}