$(document).ready(function () {
    window.gSateliteWhite.jsSelect();

    $("#btn_realizar_pago").hide();

    $("#estado_pendiente").iButton({
        'labelOn': 'PARA FACTURAR',
        'labelOff': 'PENDIENTES',
        enableDrag: false
    });

    $("#slcAlumno").select2({
        placeholder: "Buscar Alumno",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'facturacion/facturar/get_alumnos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (alumno) {
                return {
                    alumno: alumno
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.alumno,
                        'text': item.alm_nombre,
                        'cliente': item.cliente
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcAlumno").live('change', function(event) {
        alumno = $(this).val();
        if(alumno > 0) {
            var datos = $(this).select2('data');
            $("#cliente_alumno").val(datos.cliente);
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url:  window.gSateliteWhite.baseUrl('facturacion/facturar/cargar_select_cursos'),
                data: {alumno: alumno},
                beforeSend: function(){
                    $("#slcCurso").attr("placeholder", "Cargando...");
                    $("#slcCurso").select2();
                },
                success: function (data) {
                    $("#slcCurso").attr("placeholder", "Seleccione");
                    $("#slcCurso").html(data);
                    $("#slcCurso").select2();
                }
            });
        }else{
            $("#cliente_alumno").val("");
            $("#slcCurso").html('<option value=""></option>')
            $("#slcCurso").attr("placeholder", "Seleccione");
            $("#slcCurso option:first").attr('selected','selected');
            $("#slcCurso").select2();
        }
    });
    
    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var alumno = $("#slcAlumno").val();
        var curso = $("#slcCurso").val();
            
        var estado = $('#estado_pendiente').is(':checked') ? 2: 1;
        
        if(alumno > 0 && curso > 0) {
            $("#slcAlumno_error").text('');
            $("#slcCurso_error").text('');
            $("#dv_contenedor_cargo_x_curso").hide('slide',{
                direction:'right'
            }, 400, function(){
                $.ajax({
                    type:'post',
                    url:window.gSateliteWhite.baseUrl('facturacion/facturar/pago_estudiante'),
                    data: { alumno: alumno, curso: curso, estado: estado },
                    beforeSend:function(){
                        wait.start();
                    },
                    success: function (result) {
                        wait.close();

                        var oTabla = $("#tblCargoxCurso").dataTable();

                        oTabla.fnDestroy();
                        $("#tbContenedorCargoxCurso").html(result);
                        $("#dv_contenedor_cargo_x_curso").show("slide", {
                            direction: 'left'
                        }, 500);
                        aplicarDataTable('tblCargoxCurso');
                        if ($("#tblCargoxCurso tbody tr.pendiente").length > 0) {
                            $("#btn_realizar_pago").prop("disabled", true);
                            $("#btn_realizar_pago").show();
                        } else {
                            $("#btn_realizar_pago").hide();
                        }                        
                    }
                });
            });
        }else{
            $("#slcAlumno_error").text('Campo requerido');
            $("#slcCurso_error").text('Campo requerido');
        }
    });

    $("#btn_realizar_pago").click(function(event){
        event.preventDefault();
        var alumno = $("#slcAlumno").val();
        var curso = $("#slcCurso").val();
        var registrosSeleccionados = [];
        
        $("#tblCargoxCurso tbody tr").each(function() {
            var fila = $(this);
            var checkbox = fila.find("input[type='checkbox']");
        
            // Verificar si el checkbox está seleccionado
            if (checkbox.prop("checked")) {
                var cmc_id = fila.find("input[name='cmc_id[]']").val(); // Obtener el valor del cmc_id
                registrosSeleccionados.push(cmc_id);
            }
        });

        if(alumno > 0 && curso > 0 && registrosSeleccionados.length > 0) {
            $("#slcAlumno_error").text('');
            $("#slcCurso_error").text('');
            var idcliente = $("#cliente_alumno").val();

            datos = new Array();
            datos[0] = idcliente;
            datos[1] = registrosSeleccionados;

            alerta_confirm_ajax(enviarDatosFactura, datos, 'Confirmar facturacion de cuotas', '¿Ésta seguro que desea ir a facturar las cuotas seleccionadas?');

        }else{
            if(alumno == 0) {
                $("#slcAlumno_error").text('Campo requerido');                
            }
            if(curso == 0) {
                $("#slcCurso_error").text('Campo requerido');
            }
            if(registrosSeleccionados.length == 0) {
                crear_alerta('error', 'Error', 'Debe de seleccionarse al menos una cuota');
            }            
        }
    });

    $('body').on('change', '.checkear', function(event) {
        event.preventDefault();
        let chkd = 0;
        $(".checkear").each(function() {
            if ($(this).is(':checked')) {
                chkd++;
            }
        });
        if(chkd > 0) {
            $("#btn_realizar_pago").prop("disabled", false);
        } else {
            $("#btn_realizar_pago").prop("disabled", true);
        }
    });
  
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function enviarDatosFactura (datos) {
    cliente = datos[0];
    registrosSeleccionados = datos[1];
    $("#clienteid").val(cliente);
    $("#cuotaslct").val(registrosSeleccionados.toString());
    $("#frm_faturar").submit();
}