$(document).ready(function () {
    gSateliteWhite.jsSelect();
    aplidarDataTabledef('tabla_defecto');
    $('select option[value=0]').val('');
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $("#fitros_grid").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("#field-cda_impuesto").numeric();
    $("#DataTables_Table_0 img").attr('style', 'width:150px; height:75px;align:center;');
    $("#DataTables_Table_0 .image-thumbnail").addClass('verModal');
    $(".upload-success-url a:first").addClass('verModal');
    $(".verModal").fancybox({
        openEffect  : 'elastic',
        closeEffect : 'elastic'
    });

    //recorremos los 3 botones q ue tenemos y le agregamos la clase a los botones para imprimir los reportes para poder llamarlos mas facil
    $('.btn-large').each(function(){
        if($.trim($(this).text()) == 'Export'){
            $(this).addClass('pdf');
        }
        if($.trim($(this).text()) == 'Print'){
            $(this).addClass('excel');
        }
    })

    $('.pdf').live('click', function(e){
        e.preventDefault();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if(!$("#fitros_grid").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }

        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }

        var link = $(this).attr('href');
        window.open('factura/'+fecha_ini+'/'+fecha_fin+'/export');
    })

    $('.excel').live('click', function(e){
        e.preventDefault();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if(!$("#fitros_grid").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }

        if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
            crear_alerta('error','Alerta','Verifique el período de fechas.');
            return false;
          }
        }
        var link = $(this).attr('href');
        window.open('factura/'+fecha_ini+'/'+fecha_fin+'/print');
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var filEstado = $("#filEstado").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var txtcliente= $("#txtcliente").val();
        
        if(!$("#fitros_grid").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el período de fechas.');
               return false;
            }
        }
        $.ajax({
           type:'post',
           url:window.gSateliteWhite.baseUrl('facturacion/facturar/orden_venta/'+fecha_ini+'/'+fecha_fin+'/1'),
           data:{filEstado:filEstado, txtcliente:txtcliente},
           beforeSend:function(){
               wait.start();
           },
           success:function(result){
                $("#dv_contenedor_reg").html($.trim(result));
                var agregar = $("#agregar").attr('val');
                aplidarDataTable('dynamicTable');
                wait.close();
                $("#agregar").show("slide", {
                                 direction: 'left'
                        }, 530);
                $("#dv_contenedor_reg").show("slide", {
                                 direction: 'left'
                        }, 500);
                //$("#dv_contenedor_reg, #agregar").show();
           }
        });
    });

    $(".detalle_fancy_historial_pago").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        closeBtn : false,
        helpers: {
            overlay: { closeClick: false } //Disable click outside event
        },
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    });
   
    function aplidarDataTable(idTabla) {
        $('.' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

    function aplidarDataTabledef(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
            $("#txtFechaFin").removeClass('error');
            $("#txtFechaFin_error").text('');
            return true;
        }
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            $("#txtFechaFin").addClass('error');
            $("#txtFechaFin_error").text("Verifique las fechas del período");
            return false;
        }    
    }

    function carga_automatico(){
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        
        $.ajax({
            type:'post',
            url:window.gSateliteWhite.baseUrl('facturacion/facturar/orden_venta/'+fecha_ini+'/'+fecha_fin+'/1'),
            data:{filEstado:1},
            beforeSend:function(){
               wait.start();
            },
            success:function(result){
               //$('#encabezado').show();
               $("#dv_contenedor_reg").html($.trim(result));
                var agregar = $("#agregar").attr('val');
                aplidarDataTable('dynamicTable');
                wait.close();
                $("#dv_contenedor_reg, #agregar").show();
            }
        });
    }
    carga_automatico();

    $('.imprimir').live('click', function(e){
        e.preventDefault();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if(!$("#fitros_grid").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }

        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }

        var link = $(this).attr('href');
        window.open(link);
    });

    $("body").on('click', '.anular_orden', function(event) {
        event.preventDefault();
        var url_accion = $(this).attr('href');
        $("#url_accion_anular").val(url_accion);
        id_orden = url_accion.split('/').pop();
        $("#id_orden_venta_anular").val(id_orden);
        numero_orden = $(this).parents('tr').find('td:first').text().trim();
        monto_orden = $(this).parents('tr').find('td:first').next().next().next().next().text().trim();
        //$("#td_id_identificador_orden").text(numero_orden);
        $("#td_identificador_orden").text(numero_orden);
        $("#td_monto_orden").text(monto_orden);
        $("#observacion_anulacion").val('');
        $("#mostrar_formulario_modal").trigger('click');
        $("#observacion_anulacion").focus();

        //alerta_confirm($(this).attr('href'),'Anular Orden',"Esta seguro de anular la orden de venta?");
    });

    $("#mostrar_formulario_modal").fancybox({
       openEffect  : 'elastic',
       closeEffect : 'elastic'
     });

    $("#anular_orden").click(function(event) {
      id_orden= $("#id_orden_venta_anular").val();
      observacion= $("#observacion_anulacion").val().trim();
      if (observacion.trim()!='' && id_orden>0) {
            wait.start();

             url_ajax = $("#url_accion_anular").val(); //indow.satelite.base_url('facturacion/facturar/anular_orden_venta');
              $.ajax({
                  url: url_ajax,
                  type: 'POST',
                  dataType: 'json',
                  data: {
                      id_orden: id_orden,
                      observacion: observacion
                  },
                  beforeSend: function () {
                      wait.start();
                  },
                  error: function (xhr, status, error){
                   exportarError(xhr.responseText);
                   wait.close();
               },
               success: function (json) {
                    if (json.exito == 1) {
                        location.reload();
                    }
                    else {
                        crear_alerta('error','Error' ,'Ocurrió un error en anulación, favor intentar nuevamente');
                    }
                   wait.close();
               }
           });

      } else {
        crear_alerta('error','El motivo es obligatorio' ,'');
      }

    });

    $("#txtcliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
                $("#" + idElemento).select2('disable');
            }
        }
    });

    // Notas de envio
    $("body").on('click', '.nota_envio_x', function(event) {
        event.preventDefault();
        var url_accion = $(this).attr('href');
        id_nota = url_accion.split('/').pop();
        $('#activate').trigger('click');
        url_ajax = window.satelite.base_url('facturacion/facturar/imprimir_nota_envio');
        $.ajax({
            url: url_ajax,
            type: 'POST',
            dataType: 'json',
            data: {
                id_nota: id_nota
            },
            beforeSend: function () {
                wait.start();
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (data) {
                $('#controles_nota').html("");
                $('#controles_nota').html(data.html);
                $(".datePicker_envios").datepicker({
                    showButtonPanel: true,
                    changeMonth: true,
                    changeYear: true,
                    dateFormat: 'dd-mm-yy',
                    monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
                    dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
                    nextText: "Siguiente",
                    prevText: "Anterior",
                    closeText: 'Cerrar',
                    currentText: 'Hoy',
                    minDate: 0
                });
                $('#hora_entrega').timepicker();
                wait.close();
            }
        });
        return false;
    });

    $(document).on('change','#direccion_entrega2',function(){
        var text = ($(this).val() != '') ? $('option:selected',this).text() : ''; 
        $('#direccion_entrega').val(text);
    });

    $(document).on('change','#contactos_clientex',function(){
        var text = ($(this).val() != '') ? $('option:selected',this).text() : ''; 
        $('#contrato_entrega').val(text);
    }); 

    $(document).on('click','#editar_direc',function(){
        var o = $('#direccion_entrega2').attr('op');
        $('#direccion_entrega').val('');
        if (o == 0) {
            $('#direccion_entrega2').attr('op','1');
            $('#seleccionar').hide();
            $('#personalizar').show();
        }else{
            $('#direccion_entrega2').attr('op','0');
            $("#direccion_entrega2 option:selected").removeAttr("selected");
            $('#direccion_entrega2').select2();
            $('#personalizar').hide();
            $('#seleccionar').show();
        }
    });

    $(document).on('click','#editar_conta',function(){
        var c = $('#contactos_clientex').attr('op2');
        $('#contrato_entrega').val('');
        if (c == 0) {
            $('#contactos_clientex').attr('op2','1');
            $('#seletCont').hide();
            $('#editCont').show();
        }else{
            $('#contactos_clientex').attr('op2','0');
            $('#contactos_clientex option:selected').removeAttr('selected');
            $('#contactos_clientex').select2();
            $('#editCont').hide();
            $('#seletCont').show();
        }
    });

    $(document).on('click','#enviar_data',function(){
        $('#nota_envio_print').submit();
        $('#notas_envio').modal('hide');
    });


})