$(document).ready(function () {
    $("#botones").hide();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    
    $("body").on('change', '.datePicker', function (e) {
        if ($("#txtFechaIni").val() != "" && $("#txtFechaFin").val() != "") {
            verifica_fecha($("#txtFechaIni").val(), $("#txtFechaFin").val());
        }
    });

    $("#txt_cliente").select2({
        placeholder:'Buscar Cliente',
        minimumInputLength: 3,
        ajax: {
            url:urlj + 'cotizaciones/cotizaciones/get_clientes',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#btnConsultar").click(function(event){
        event.preventDefault();
        $("#botones").hide();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var cliente = $("#txt_cliente").val();
        if (fecha_ini != "" && fecha_fin != "") {
            verifica_fecha(fecha_ini, fecha_fin);
            $("#dv_contenedor_reg").hide('slide', { direction: 'right' }, 400, function(){
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: urlj + 'facturacion/reportes/notas_no_facturadas/1',
                    data:{
                        fecha_ini: fecha_ini,
                        fecha_fin: fecha_fin,
                        cliente_id: cliente,
                        tipo_reporte: ""
                    },
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(result){
                        $("#dv_contenedor_reg").html(result.html);
                        if (result.filas > 0) {
                            $("#botones").show();
                            $("#fecha_ini").val(fecha_ini);
                            $("#fecha_fin").val(fecha_fin);
                            $("#cliente_id").val(cliente);
                        }
                        $("#dv_contenedor_reg").show("slide", { direction: 'left' }, 500);
                        wait.close();
                    }
                });
            });
        } else {
            crear_alerta('error', 'Atención', 'Verifique las fechas del período');
            return false;
        }
    });   

});

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").val("");
        crear_alerta('error', 'Atención', 'Verifique las fechas del período');
        return false;
    } else {
        return true;
    }
}