$(document).ready(function () {
    gSateliteWhite.jsSelect();
    aplidarDataTabledef('tabla_defecto');
    $('select option[value=0]').val('');
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    $("#slcEstado").select2();

    $("#factura_grid").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true},
            // pag_cliente:{ required:true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            alert();
            //form.submit();
        }
    });


    $("#field-cda_impuesto").numeric();
    $("#DataTables_Table_0 img").attr('style', 'width:150px; height:75px;align:center;');
    $("#DataTables_Table_0 .image-thumbnail").addClass('verModal');
    $(".upload-success-url a:first").addClass('verModal');
    $(".verModal").fancybox({
        openEffect  : 'elastic',
        closeEffect : 'elastic'
    });
    //recorremos los 3 botones q ue tenemos y le agregamos la clase a los botones para imprimir los reportes para poder llamarlos mas facil
    $('.btn-large').each(function(){
        if($.trim($(this).text()) == 'Export'){
            $(this).addClass('pdf');
        }
        if($.trim($(this).text()) == 'Print'){
            $(this).addClass('excel');
        }
    })

    $('.pdf').live('click', function(e){
        e.preventDefault();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if(!$("#factura_grid").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }

        if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
            crear_alerta('error','Alerta','Verifique el período de fechas.');
            return false;
          }
        }

        var link = $(this).attr('href');
        window.open('factura/'+fecha_ini+'/'+fecha_fin+'/export');
    })
    //imprime los datos de la factura
    $('.excel').live('click', function(e){
        e.preventDefault();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if(!$("#factura_grid").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }

        if(fecha_ini !='' && fecha_fin != ''){
          if(!verifica_fecha(fecha_ini,fecha_fin)){
            crear_alerta('error','Alerta','Verifique el período de fechas.');
            return false;
          }
        }
        var link = $(this).attr('href');
        window.open('factura/'+fecha_ini+'/'+fecha_fin+'/print');
    })

    $(".duplicar_garantia").live('click', function(e){
        e.preventDefault();
        var link = $(this).attr('href');
        window.open(link, '_blank');
    })
    $(".mostrar_historial").live('click', function(e){
        e.preventDefault();
        var href = $(this).attr('href').split("/historial/");
        var id = href[1];

        $('#facy_history').attr('id_historial', id);
        $('#facy_history').click();
        
        /*var link = $(this).attr('href');
        window.open(link, '_blank');*/
    })

    /*$("#btnConsultar").click(function(){
        if($("#txtFechaIni").val()!='' || $("#txtFechaFin").val()!=''){
            $("#factura_grid").submit();
            //location.href = urlj+'tarificador/entradas/codigo_paises/'+pais+'/'+codigo;
        }else{
            crear_alerta('error','Nota','Debe completar al menos un filtro de búsqueda.');
        }
    });*/

    $('#facy_history').live('click', function(){
        var id = $(this).attr('id_historial')
        console.log(id);
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'facturacion/facturar/ver_pagos',
            data: {factura:id},
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                console.log(data);
                wait.close();
                $('#historial_pago').html(data.tabla);
            }
        })
    })
    //proceso para seguimiento de facturas que aplican domicilio
    $('.fac_domicilio').live('click', function(e){
        e.preventDefault();
        var href = $(this).attr('href').split("/historial_domicilio/");
        var id = href[1];
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'facturacion/facturar/historial_domicilio',
            data: {factura:id},
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                console.log(data);
                wait.close();
                $('#aplica_domicilio').html(data.resultado);
                $('#fancy_aplica_domicilio').click();
                //var cliente = $("#cliente").val();
                /*if ( cliente == "" ) {
                    crear_alerta('error','Alerta','El cliente no se encuentra activo, la edición no es posible');
                    return false;
                } else {
                    $('#edit_fact').click();
                }*/
            }
        })
        
    });
    $('.editar').live('click', function(e){
        e.preventDefault()
        var href = $(this).attr('href').split("/editar_factura/");
        var id = href[1];
        console.log(id);

        $('#edit_fact').attr('id_factura', id);
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'facturacion/facturar/editar_factura',
            data: {factura:id},
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                console.log(data);
                wait.close();
                $('#editar_factura').html(data.resultado);

                var cliente = $("#cliente").val();
                if ( cliente == "" ) {
                    crear_alerta('error','Alerta','El cliente no se encuentra activo, la edición no es posible');
                    return false;
                } else {
                    $('#edit_fact').click();
                }
            }
        })
    })

    $(".detalle_fancy_historial_pago").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        closeBtn : false,
        helpers: {
            overlay: { closeClick: false } //Disable click outside event
        },
        beforeLoad: function () {
            
        },
        beforeClose: function () {

        }
    });

    $(".aplica_domicilio_fancy").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        closeBtn : false,
        helpers: {
            overlay: { closeClick: false } //Disable click outside event
        },
        beforeLoad: function () {
            
        },
        beforeClose: function () {

        }
    });

    $("#pag_cliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
                $("#" + idElemento).select2('disable');
            }
        }
    });

    $("#pag_cliente").change(function(event){
        var cliente = $(this).val();
        CargarSucursales(cliente);
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        //alert();        
        //var documento = $("#slcDocumento").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var tipoFactura = $("#tipo_fac").val();
        var user = $("#usuario").val();

        if(user!=''){
            usu = '/'+user;
        }else{
            usu = '';
        }
        
        if(!$("#factura_grid").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el período de fechas.');
               return false;
            }
        }
        $.ajax({
           type:'post',
           url:window.gSateliteWhite.baseUrl('facturacion/facturar/nota_credito/'+fecha_ini+'/'+fecha_fin+'/1'+usu),
           data:{
            txtFechaIni: $("#txtFechaIni").val(),
            txtFechaFin: $("#txtFechaFin").val(),
            tipo_fac:    $("#tipo_fac").val(),
            pag_cliente:    $("#pag_cliente").val()
           },
           beforeSend:function(){
               wait.start();
           },
           success:function(result){
                $("#dv_contenedor_reg").html($.trim(result));
                var agregar = $("#agregar").attr('val');

                aplidarDataTable('dynamicTable');
                wait.close();
                $("#dv_contenedor_reg, #agregar").show();
                //PROCESO PARA APLICAR BACKGROUND A LOS TR QUE SON FACTURAS QUE APLICAN A DOMICILIO
                colorDomicilio();
           }
        });
    });
   
    function aplidarDataTable(idTabla) {
        $('.' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "aaSorting": [[ 4, "desc" ]], //ordena desc
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

    function aplidarDataTabledef(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "aaSorting": [[ 4, "desc" ]], //ordena desc
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
            $("#txtFechaFin").removeClass('error');
            $("#txtFechaFin_error").text('');
            return true;
        }
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            $("#txtFechaFin").addClass('error');
            $("#txtFechaFin_error").text("Verifique las fechas del período");
            return false;
        }    
    }

    function cargar_factura(){
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        
        $.ajax({
           type:'post',
           url:window.gSateliteWhite.baseUrl('facturacion/facturar/nota_credito/'+fecha_ini+'/'+fecha_fin+'/1'),

           beforeSend:function(){
               wait.start();
           },
           success:function(result){
               //$('#encabezado').show();
                $("#dv_contenedor_reg").html($.trim(result));
                var agregar = $("#agregar").attr('val');

                aplidarDataTable('dynamicTable');
                wait.close();
                $("#dv_contenedor_reg, #agregar").show();
                 //PROCESO PARA APLICAR BACKGROUND A LOS TR QUE SON FACTURAS QUE APLICAN A DOMICILIO
                $('.color_tr').each(function(index, row){
                    var color = $(this).data('color'); //atributo data-color tiene el color del background
                    $(this).parents('tr').css({'background-color': color});//aplico css para el background
                });
                
                
           }
        });
    }
     //proceso para seguimiento de facturas que aplican domicilio
    $('.fac_domicilio').live('click', function(e){
        e.preventDefault();
        var href = $(this).attr('href').split("/historial_domicilio/");
        var id = href[1];
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'facturacion/facturar/historial_domicilio',
            data: {factura:id},
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                console.log(data);
                wait.close();
                $('#aplica_domicilio').html(data.resultado);
                $('#fancy_aplica_domicilio').click();
                //var cliente = $("#cliente").val();
                /*if ( cliente == "" ) {
                    crear_alerta('error','Alerta','El cliente no se encuentra activo, la edición no es posible');
                    return false;
                } else {
                    $('#edit_fact').click();
                }*/
            }
        })
        
    });
    cargar_factura();
    colorDomicilio();
    $('body').on('mouseover', '#DataTables_Table_0_paginate', function(e){
        colorDomicilio();
        
    });
    $('body').on('keyup', '#search', function(e){
        colorDomicilio();
    });
})
//PROCESO PARA APLICAR BACKGROUND A LOS TR QUE SON FACTURAS QUE APLICAN A DOMICILIO
function colorDomicilio(){
     $('.color_tr').each(function(index, row){
        var color = $(this).data('color'); //atributo data-color tiene el color del background
        $(this).parents('tr').css({'background-color': color});//aplico css para el background
    });
}

    function CargarSucursales(cliente) {
        var forma_facturacion = $("#slc_forma_facturacion").val();
      $.ajax({
          dataType: 'json',
          type: 'POST',
          url: urlj+'modulo_cuentas_cobrar/procesos/obtener_sucursal',
          data: {cliente:cliente,forma_facturacion:forma_facturacion},
          beforeSend: function () {
              if($.trim(cliente) != ''){
                  wait.start();
              }
          },
          success: function(data){
            $("#slc_sucursal").html(data.sucursales);
            $("#slc_sucursal option[value='0']").text('');
            $("#slc_sucursal option[value='0']").val('');
            $("#slc_sucursal").select2({placeholder: "Seleccione una opción"});
            wait.close();
          }
      })
    }