var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;
$(document).ready(function(){
  
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});

    $("input[name^='fecha']").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true, 
        changeYear: true,
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior"
    });
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");

    $("#caja").select2();
    $("#estado").select2();
    $("#slc_area").select2();
    $("#slc_tipo_pago").select2();

    $("#filtro").click(function(event){
        event.preventDefault();
        var caja      = $("#caja").val();
        var fecha_ini = $("#fecha_inicio").val();
        var fecha_fin = $("#fecha_fin").val();
        var estado    = $("#estado").val();
        var area      = $("#slc_area").val();
        var tipo_pago = $("#slc_tipo_pago").val();
        var tipo_fact = $("#slc_tipo_fact").val();
        var monto_min = $("#monto_min").val();
        /*if ( caja == "" ) {
            crear_alerta('error','Caja','Campo caja es requerido.');        
            return false;
        }*/
        if ( fecha_ini == "" || fecha_fin == "" ) {
            crear_alerta('error','Período','Campos de períodos son requeridos.');        
            return false;
        }    
        if(fecha_ini!='' && fecha_fin!=''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Período','Verificar período de fechas.');       
                return false; 
            }
        }
        /*if ( estado == "" ) {
            crear_alerta('error','Estado','Campo estado es requerido.');        
            return false;
        }*/
        wait.start();
        $.ajax({
            url: urlj+'facturacion/reportes/consultar_historial_cajas',
            type: 'POST',
            dataType: 'json',
            data: {
                caja:caja, 
                fecha_ini:fecha_ini, 
                fecha_fin:fecha_fin, 
                estado:estado, 
                area:area,
                monto_min:monto_min,
                tipo_pago:tipo_pago,
                tipo_fact:tipo_fact
            },
            success:function(data) {            
                $("#carga_datos").html(data.html);
                if($("#sin_registros").length <= 0 ){
                    //$("#cajas").dataTable();
                    setTimeout(function() {
                        wait.close();
                    }, 100);
                } else {
                    wait.close();
                }

                $("#cajas").show();
                $("#descargar").show();
                $(".form-actions").show('slow');
                $(".botones_export_print").show('slow');
            }
        });

        /* if ($("#fecha_inicio").val()<=0 && $("#fecha_fin").val()<=0 &&  $("#caja").val()<=0) {
            $("#fecha_inicio_error").text('Campo requerido');
            $("#fecha_fin_error").text('Campo requerido');
            $("#cliente_error").text('Campo requerido');
        }else if ($("#caja").val()<=0) {
             $("#cliente_error").text('Campo requerido');

        }else if ($("#fecha_inicio").val()<=0) {
            $("#fecha_inicio_error").text('Campo requerido');
        }else if ($("#fecha_fin").val()<=0) {
            $("#fecha_fin_error").text('Campo requerido');
        } */
    });

    $("#fecha_inicio").focus(function(event){
        $("#fecha_inicio").removeClass('error');
        $("#fecha_inicio_error").text('');
    });

    $("#fecha_fin").focus(function(event){
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
    });

    $("#caja").change(function(event){
        $("#caja").removeClass('error');
        $("#cliente_error").text('');
    });

    // $("#fecha_fin").change(function(){
    //   var fecha_ini = $("#fecha_inicio").val();
    //   var fecha_fin = $("#fecha_fin").val();
    //   if(fecha_ini!='' && fecha_fin!=''){
    //       verifica_fecha(fecha_ini,fecha_fin);
    //   }
    //   else{
    //       $("#fecha_fin_error").text("Verifique las fechas del período");
    //   }
    // });

    function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        // var f1 = new Date(fecha_i);
        // var f2 = new Date(fecha_f);
        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}

        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            crear_alerta('error','Error','Verifique las fechas del período');
            //$("#fecha_fin_error").text("Verifique las fechas del período");
            return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
            $("#fecha_fin_error").text('');
            return true;
        }
    }


    $('body').on('click',"a[href ^= '" + gSateliteWhite.baseUrl("modulo_contabilidad/procesos/ver_partida_modal") + "']", function (event) {
        event.preventDefault();
        generar_ventana($(this).attr('href'), "DETALLE DE PARTIDA CONTABLE");
    });

});


function generar_ventana(url, title, w, h) {
    w = typeof w !== 'undefined' ? w : 700;
    h = typeof h !== 'undefined' ? h : 500;   
    title = typeof title !== 'undefined' ? title : 'DETALLES - ' + document.title;   
    
    // Fixes dual-screen position                         Most browsers      Firefox
    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : window.screenX;
    var dualScreenTop = window.screenTop != undefined ? window.screenTop : window.screenY;

    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

    var systemZoom = width / window.screen.availWidth;
    var left = (width - w) / 2 / systemZoom + dualScreenLeft
    var top = (height - h) / 2 / systemZoom + dualScreenTop
    var newWindow = window.open(url, title, 'scrollbars=yes, width=' + w / systemZoom + ', height=' + h / systemZoom + ', top=' + top + ', left=' + left);

    // Puts focus on the newWindow
    if (window.focus) newWindow.focus();
}