var urlj = url_base_proyecto;

$(document).ready(function(){
    $("select").select2();

    $("#filtrarCajero").iButton({ 'labelOn': 'Si', 'labelOff': 'No'});
    $("#filtrarCaja").iButton({ 'labelOn': 'Si', 'labelOff': 'No'});

    $("select option[value='0']").val('');
    $("input[name^='fecha']").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true, 
        changeYear: true,
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior"
    });
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");

    $("#filtro").click(function () {
        var fecha_inicio = $("#fecha_inicio").val();
        var fecha_fin = $("#fecha_fin").val();
        var slcCaja   = $("#slcCaja").val();

        if (fecha_inicio != '' && fecha_fin != '') {
            if (!verifica_fecha(fecha_inicio, fecha_fin)) {
                return false;
            }
        }
        if (fecha_inicio == ''){
            crear_alerta('error','Error','Verifique la fecha de inicio');
        }else if(fecha_fin == ''){
            crear_alerta('error','Error','Verifique la fecha final');
        }else if(slcCaja == null){
            crear_alerta('error','Error','Verifique la caja que desea consultar');
        }else if(slcCaja != null) {
            $.ajax({
                url: urlj + 'facturacion/reportes/consultar_historial_caja_cajero',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    slcCaja: slcCaja,
                    fecha_inicio: fecha_inicio, 
                    fecha_fin: fecha_fin
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    //console.log(data);
                    $("#carga_datos").html(data.html);
                    $("#cajas").show();
                    $("#descargar").show();
                    $(".form-actions").show('slow');
                    $(".botones_export_print").show('slow');
                    wait.close();
                }
            });
        }
        

    });

    


    function verifica_fecha(fecha_inicio, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_inicio.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if(Date.parse(fecha_i) == Date.parse(fecha_f)){
            $("#fecha_fin_error").text(''); return true;
        }
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          crear_alerta('error','Error','Verifique las fechas del período');
          return false;
        }
        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin_error").text('');
          return true;
        }
    }
}); // End jQuery
