$(document).ready(function() {

    $("#caja").select2();
    // Se configuro para solo mostrar el mes 
    $("#frm_corte_mensual_z .datePicker").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: false,
        showButtonPanel: true,
        dateFormat: 'mm-yy',
        onClose: function(dateText, inst) { 
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    // Ocultar el calendario para solo mostrar el mes
    $("#frm_corte_mensual_z .datePicker").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });

    /*
        Validaciones que debe tener:
        1- Se debe colocar por mes
        2- Se debe validar que sea el mes actual y el ultimo dia
        3- No debe generarse nuevamente, solo reimprimirlo 
        4- Emitir una alerta "no se ha hecho el corte Z mensual y debe ser solo por mes"
    */

    $("#btn_consultar").on("click", function(event) {
        event.preventDefault();
        // Valor actual del mes
        var separador      = $("#txtMes").val().split('-');
        var month          = (parseInt(separador[0]));

        // Obtener la fecha actual
        fecha_elegida = (parseInt(separador[1]))+","+(parseInt(separador[0]))+",01";

        var tiempo          = new Date(fecha_elegida);
        var diaActual       = tiempo.getDate();
        var mesActual       = tiempo.getMonth() + 1;
        var anioActual      = tiempo.getFullYear();

        // Ultimo dia del mes
        var ultimoDia       = new Date(anioActual, mesActual, 0);

        var dia     = ultimoDia.getDate();
        var mes     = ultimoDia.getMonth() + 1;
        var year    = ultimoDia.getFullYear();

        // Primer Dia del mes actual
        var desde   = ('00' + 1).slice(-2) + "-" + ('00' + mesActual).slice(-2) + "-" + anioActual; 
        // Ultima fecha del mes actual
        var hasta   = ('00' + dia).slice(-2) + "-" + ('00' + mes).slice(-2) + "-" + year;

        var caja    = $("#caja").val();
        var respuesta = false;

        if ( caja == "") {
            crear_alerta('error', 'Generación Corte Z Mensual', 'Seleccione una caja.');
            $("#caja").val(0);
            $("#caja").select2();
            $("#slc_estado").val("");
            return false;
        } 

        if (!(month === mesActual)) {
            //crear_alerta('error', 'Generación Corte Z Mensual', 'Solo puedes Generar Corte Mensual Z del mes actual');
            //return false;
        }
        

        if (!(diaActual === dia)) {
            //crear_alerta('error', 'Generación Corte Z Mensual', 'Solo puedes realizar Corte Mensual Z el ultimo dia del mes');
            //return false;
        } 

        $("#fechaInicio").val(desde);
        $("#fechaFin").val(hasta);

        setTimeout(function() {
        verificar_existe();
        }, 100);
    });




    //===============================================
    // CONSULTAR LOS CORTES YA ELABORADOS.
    //================================================
    $("#caja_consulta").select2();
    $("#txtFecha_desde, #txtFecha_hasta").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("#txtFecha_desde, #txtFecha_hasta").mask('99-99-9999');
    $("#txtFecha_desde, #txtFecha_hasta").focus(function(event) {
        $(".ui-datepicker-calendar").show();
    });
    $("#btn_consultar_corte").click(function(event) {
        /* Act on the event */
        event.preventDefault();
        id_caja = $("#caja_consulta").val();
        if (id_caja > 0 ) 
        {
            $("#contenedorTabla").hide("slide", { 
            direction: 'right'
            }, 400, function() {
                  url_ajax = window.satelite.base_url('facturacion/facturar/filtrar_corte_mensual');
                   $.ajax({
                       url: url_ajax,
                       type: 'POST',
                       dataType: 'json',
                       data: {
                           id_caja: id_caja,
                           txtFecha_inicio: $("#txtFecha_desde").val(),
                           txtFecha_hasta: $("#txtFecha_hasta").val()
                       },
                       beforeSend: function () {
                           wait.start();
                       },
                       error: function (xhr, status, error){
                        exportarError(xhr.responseText);
                        wait.close();
                    },
                    success: function (json) {
                        $("#contenedorTabla").html(json.html);
                        $("#contenedorTabla").show("slide", {
                          direction: 'left'
                        }, 500);
                        wait.close();

                    }
                });
               });
        }
        else 
        {
            crear_alerta('error', 'Caja es requerida','');
        }
    });

});


function  verificar_existe() {
        id_caja    = $("#caja").val();
      if (id_caja > 0 && $("#fechaInicio").val().trim() != '' && $("#fechaFin").val().trim() != '') 
      {
          url_ajax = window.satelite.base_url('facturacion/facturar/verificar_existe_corte');
           $.ajax({
               url: url_ajax,
               type: 'POST',
               dataType: 'json',
               data: {
                   id_caja: id_caja,
                   txtFecha_inicio: $("#fechaInicio").val(),
                   txtFecha_hasta: $("#fechaFin").val()
               },
               beforeSend: function () {
                   wait.start();
               },
               error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                if (json.existe == 1) {
                    crear_alerta('error', 'El periodo selecionado ya posee un corte','');
                    wait.close();
                } 
                else
                {   
                    $("#frm_corte_mensual_z").submit();
                    wait.close();
                }  
            }
        });
   }
   else 
   {
     crear_alerta('error', 'Caja es requerida','');
   }
}
