$(document).ready(function () {
    gSateliteWhite.jsSelect();
    aplidarDataTabledef('tabla_defecto');
    $('select option[value=0]').val('');
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    $("#slcEstado").select2();

    $("#factura_grid").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });


    $("#field-cda_impuesto").numeric();
    $("#DataTables_Table_0 img").attr('style', 'width:150px; height:75px;align:center;');
    $("#DataTables_Table_0 .image-thumbnail").addClass('verModal');
    $(".upload-success-url a:first").addClass('verModal');
    $(".verModal").fancybox({
        openEffect  : 'elastic',
        closeEffect : 'elastic'
    });
    //recorremos los 3 botones q ue tenemos y le agregamos la clase a los botones para imprimir los reportes para poder llamarlos mas facil
    $('.btn-large').each(function(){
        if($.trim($(this).text()) == 'Export'){
            $(this).addClass('pdf');
        }
        if($.trim($(this).text()) == 'Print'){
            $(this).addClass('excel');
        }
    })

    $('.pdf, .btnCrudExport').live('click', function(e){
        e.preventDefault();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var tipo_fac  = $("#tipo_fac").val();
        var stado_fac = $("#slcEstado").val();
        var tpf = (tipo_fac != "" && tipo_fac > 0) ? '/null/'+tipo_fac : '';
        if (stado_fac != "" && stado_fac > 0) {
            if (tpf != '') {
                tpf += '/' + stado_fac; 
            } else {
                tpf += '/null/null/' + stado_fac;
            }
        }
        if(!$("#factura_grid").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }
        var link = $(this).attr('href');
        window.open('factura/'+fecha_ini+'/'+fecha_fin+'/export'+tpf);
    })
    //imprime los datos de la factura
    $('.excel, .btnCrudPrint').live('click', function(e){
        e.preventDefault();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var tipo_fac  = $("#tipo_fac").val();
        var stado_fac = $("#slcEstado").val();
        var tpf = (tipo_fac != "" && tipo_fac > 0) ? '/null/'+tipo_fac : '';
        if (stado_fac != "" && stado_fac > 0) {
            if (tpf != '') {
                tpf += '/' + stado_fac; 
            } else {
                tpf += '/null/null/' + stado_fac;
            }
        }
        if(!$("#factura_grid").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }
        var link = $(this).attr('href');
        window.open('factura/'+fecha_ini+'/'+fecha_fin+'/print'+tpf);
    });

    $(".duplicar_garantia").live('click', function(e){
        e.preventDefault();
        var link = $(this).attr('href');
        window.open(link, '_blank');
    })
    
    $(".mostrar_historial").live('click', function(e){
        e.preventDefault();
        var href = $(this).attr('href').split("/historial/");
        var id = href[1];
        $('#facy_history').attr('id_historial', id);
        $('#facy_history').click();
    })

    $(".modal_ret_pdte").live('click', function(e){
        e.preventDefault();
        var href = $(this).attr('href').split("retencion/");
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'facturacion/facturar/aplicar_comprobante_retencion',
            data: {
                factura: href[1]
            },
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                $('#detalles_retenciones').html(data.tabla_retencion);
                wait.close();
                if ($.trim(data.tabla_retencion) != "" ) {
                    $('#facy_retpdte').data('factura', href[1]);
                    $('#facy_retpdte').click();
                } else {
                    crear_alerta('error', 'No es posible realizar la acción');
                    return false();
                }
            }
        });
    });

    $('#facy_history').live('click', function(){
        var id = $(this).attr('id_historial')
        // console.log(id);
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'facturacion/facturar/ver_pagos',
            data: {factura:id},
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                console.log(data);
                wait.close();
                $('#historial_pago').html(data.tabla);
            }
        })
    })
    //proceso para seguimiento de facturas que aplican domicilio
    $('.fac_domicilio').live('click', function(e){
        e.preventDefault();
        var href = $(this).attr('href').split("/historial_domicilio/");
        var id = href[1];
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'facturacion/facturar/historial_domicilio',
            data: {factura:id},
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                console.log(data);
                wait.close();
                $('#aplica_domicilio').html(data.resultado);
                $('#fancy_aplica_domicilio').click();
                //var cliente = $("#cliente").val();
                /*if ( cliente == "" ) {
                    crear_alerta('error','Alerta','El cliente no se encuentra activo, la edición no es posible');
                    return false;
                } else {
                    $('#edit_fact').click();
                }*/
            }
        })
        
    });
    $('.editar').live('click', function(e){
        e.preventDefault()
        var href = $(this).attr('href').split("/editar_factura/");
        var id = href[1];
        console.log(id);

        $('#edit_fact').attr('id_factura', id);
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'facturacion/facturar/editar_factura',
            data: {factura:id},
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                console.log(data);
                wait.close();
                $('#editar_factura').html(data.resultado);

                var cliente = $("#cliente").val();
                if ( cliente == "" ) {
                    crear_alerta('error','Alerta','El cliente no se encuentra activo, la edición no es posible');
                    return false;
                } else {
                    $('#edit_fact').click();
                }
            }
        })
    })

    $(".detalle_fancy_historial_pago").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        closeBtn : false,
        helpers: {
            overlay: { closeClick: false } //Disable click outside event
        },
        beforeLoad: function () {
            
        },
        beforeClose: function () {

        }
    });

    $(".aplica_domicilio_fancy").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        closeBtn : false,
        helpers: {
            overlay: { closeClick: false } //Disable click outside event
        },
        beforeLoad: function () {
            
        },
        beforeClose: function () {

        }
    });

    $(".det_fancy_comprobante_retenc").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        closeBtn : false,
        helpers: {
            overlay: { closeClick: false } //Disable click outside event
        },
        beforeLoad: function () {            
        },
        beforeClose: function () {
        }
    });

    $("#save_comp_reten").click(function(){
        var agrego = $(".addd").length;
        var datos = $("#frm_retencion_pdte").serialize();
        if (agrego > 0) {
            $.ajax({
                type:'POST',
                url: urlj + 'facturacion/facturar/apply_comp_ret_pdte',
                data:{
                    input_data: datos
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(result){
                    wait.close();
                    if (result > 0) {
                        $("#btnConsultar").trigger('click');
                        crear_alerta('success', 'Se proceso de forma correcta');
                        $.fancybox.close();
                    } else {
                        crear_alerta('error', 'Ocurrió un error');
                        return false;
                    }
                }
            });
        } else {
            crear_alerta('warning', 'No ha agregado ningun comprobante');
            return false;
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        //var documento = $("#slcDocumento").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var tipoFactura = $("#tipo_fac").val();
        var user = $("#usuario").val();
        var estado = $("#slcEstado").val();
        if(user!=''){
            usu = '/'+user;
        }else{
            usu = '';
        }
        
        if(!$("#factura_grid").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el período de fechas.');
               return false;
            }
        }
        $.ajax({
            type:'post',
            url:window.gSateliteWhite.baseUrl('facturacion/facturar/factura/' + fecha_ini + '/' + fecha_fin + '/1' + usu),
            data:{
                txtFechaIni: $("#txtFechaIni").val(),
                txtFechaFin: $("#txtFechaFin").val(),
                tipo_fac:    $("#tipo_fac").val(),
                estado:      $("#slcEstado").val()            
           },
           beforeSend:function(){
               wait.start();
           },
           success:function(result){
                $("#dv_contenedor_reg").html($.trim(result));
                var agregar = $("#agregar").attr('val');

                aplidarDataTable('dynamicTable');
                wait.close();
                $("#dv_contenedor_reg, #agregar").show();
                //PROCESO PARA APLICAR BACKGROUND A LOS TR QUE SON FACTURAS QUE APLICAN A DOMICILIO
                colorDomicilio();
           }
        });
    });
   
    function aplidarDataTable(idTabla) {
        $('.' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 10,
            "bLengthChange": true,
            // "aaSorting": [[ 4, "desc" ]], //ordena desc
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

    function aplidarDataTabledef(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 10,
            "bLengthChange": true,
            // "aaSorting": [[ 4, "desc" ]], //ordena desc
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
            $("#txtFechaFin").removeClass('error');
            $("#txtFechaFin_error").text('');
            return true;
        }
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            $("#txtFechaFin").addClass('error');
            $("#txtFechaFin_error").text("Verifique las fechas del período");
            return false;
        }    
    }

    function cargar_factura(){
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        
        $.ajax({
           type:'post',
           url:window.gSateliteWhite.baseUrl('facturacion/facturar/factura/'+fecha_ini+'/'+fecha_fin+'/1'),

           beforeSend:function(){
               wait.start();
           },
           success:function(result){
               //$('#encabezado').show();
                $("#dv_contenedor_reg").html($.trim(result));
                var agregar = $("#agregar").attr('val');

                aplidarDataTable('dynamicTable');
                wait.close();
                $("#dv_contenedor_reg, #agregar").show();
                 //PROCESO PARA APLICAR BACKGROUND A LOS TR QUE SON FACTURAS QUE APLICAN A DOMICILIO
                $('.color_tr').each(function(index, row){
                    var color = $(this).data('color'); //atributo data-color tiene el color del background
                    $(this).parents('tr').css({'background-color': color});//aplico css para el background
                });
                
                
           }
        });
    }
     //proceso para seguimiento de facturas que aplican domicilio
    $('.fac_domicilio').live('click', function(e){
        e.preventDefault();
        var href = $(this).attr('href').split("/historial_domicilio/");
        var id = href[1];
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj+'facturacion/facturar/historial_domicilio',
            data: {factura:id},
            beforeSend: function() {
                wait.start();
            },
            success: function(data){
                console.log(data);
                wait.close();
                $('#aplica_domicilio').html(data.resultado);
                $('#fancy_aplica_domicilio').click();
                //var cliente = $("#cliente").val();
                /*if ( cliente == "" ) {
                    crear_alerta('error','Alerta','El cliente no se encuentra activo, la edición no es posible');
                    return false;
                } else {
                    $('#edit_fact').click();
                }*/
            }
        })
        
    });
    cargar_factura();
    colorDomicilio();
    $('body').on('mouseover', '#DataTables_Table_0_paginate', function(e){
        colorDomicilio();
        
    });
    $('body').on('keyup', '#search', function(e){
        colorDomicilio();
    });

    $('body').on('click', 'a.imprimir', function(event){
        wait.start('Cargando impresión... espere unos segundos');
        event.preventDefault();
        url_print = $(this).attr('href');
        html_ = '<iframe src="'+url_print+'" id="iframePrint" style="height:400px;width:800px;"></iframe>';
        $("#dvPrint").html(html_);
        cargandoIframe('iframePrint');
    });

    // RETENCIONES
    $("#agregar_detalle_ret").live("click", function(){
        var factura = $(this).attr('factura');
        var mensaje = "";
        var nochek = 0;///////////////////////////////////////////////////////////////////////
        var acumulador = $("#contador_acumulador"+factura).val();
        var validar_select_total = 0;
        var validar_retencion_total = 0;
        var contador_select_total = 0;
        var repetido = 0;
        var contador_porcentaje = 0;
        var validar_fecha = 0;
        var comprobante_reten = $("#num_comprobante").val();////////////////////////////////////$("#comprobante_"+factura).val();
        var fecha_reten = $("#fec_comprobante").val();//////////////////////////////////////////$("#fecha_"+factura).val();
        if (comprobante_reten != "" && fecha_reten != "") {
            $(".selecciones_detalles_retenciones_"+factura).each(function(){
                var detalle = $(this).attr('detalle');
                if($("#checkbox_detalle_"+detalle).prop("checked")){
                    var retenciones_ids = $("#select_ret_"+detalle).val();
                    var retenciones_text = $("#mostrar_tretencion_div_"+detalle).text();
                    contador_select_total++;
                    if(retenciones_ids != null && retenciones_text != ""){
                        validar_retencion_total++;
                        if($.trim(comprobante_reten) != ""){
                            if(!($("#comprobante_fac"+factura+comprobante_reten).length <= 0)){
                                repetido = 1;
                            }
                            var porcentaje_acumulado = parseFloat(number_format($("#retencion_porcentaje_acum_"+detalle).val(), 2, '.', ''));
                            var porcentaje_actual = parseFloat(number_format($("#retencion_porcentaje_actu_"+detalle).val(), 2, '.', ''));
                            if((porcentaje_acumulado+porcentaje_actual) > parseFloat(100.00)){
                                contador_porcentaje++;
                            }
                            validar_select_total++;
                        }
                        if($.trim(fecha_reten) != ""){
                            validar_fecha++;
                        }
                    }
                }
            });
            var contador_retencion = 0;//parseFloat(validar_retencion);
            $(".selecciones_detalles_retenciones_"+factura).each(function(){
                var detalle = $(this).attr('detalle');
                if($("#checkbox_detalle_"+detalle).prop("checked")){
                    nochek++;
                    var id_correlativo = $('#contador_comprobante_detall_'+factura).val();
                    var comprobante_reten = $("#num_comprobante").val();
                    var fecha_producto_det = $("#fec_comprobante").val();
                    var codigo_producto = $("#codigo_producto_ret_"+detalle).text();
                    var descripcion_producto = $("#label_descripcion_prod_"+detalle).text();
                    var total_producto = $("#input_retencion_total_"+detalle).val();
                    var retencion_porcentaje = $("#label_retencion_text_"+detalle).text();
                    var retencion_porcentaje_valor = $("#input_retencion_text_"+detalle).val();
                    var retenciones_text = $("#mostrar_tretencion_div_"+detalle).text();
                    var retenciones_ids = $("#select_ret_"+detalle).val();
                    var retenciones_indi_id = $("#retencion_porcentaje_indi_"+detalle).val();
                    if(retenciones_ids != null && retenciones_text != ""){
                        if(validar_select_total > 0 && validar_fecha > 0 && validar_retencion_total == contador_select_total && repetido == 0){
                            if(contador_porcentaje == 0){
                                contador_retencion += parseFloat(retencion_porcentaje_valor);
                                id_comprobar = '<input type="hidden" name="existe'+detalle+acumulador+'" value="0" />';
                                id_comprobante_reten = '<input type="hidden" id="comprobante_fac'+factura+comprobante_reten+'" name="comprobante_fac'+factura+acumulador+'[]" value="'+comprobante_reten+'" />';
                                id_factura = '<input type="hidden" name="ret_def_'+factura+acumulador+'[]" value="'+detalle+'" /><input type="hidden" class="addd" id="addd" name="addd[]" value="1">';
                                id_codigo_producto = '<input type="hidden" name="codigo_producto'+detalle+'[]" value="'+codigo_producto+'" />';
                                id_descripcion_producto = '<input type="hidden" name="descripcion_producto'+detalle+'[]" value="'+descripcion_producto+'" />';
                                id_total_producto = '<input type="hidden" name="total_producto'+detalle+acumulador+'" value="'+total_producto+'" />';
                                id_retencion_porcentaje = '<input type="hidden" name="retencion_porcentaje'+detalle+acumulador+'" value="'+retencion_porcentaje_valor+'" />';
                                id_retenciones_ids = '<input type="hidden" name="retenciones_ids'+detalle+acumulador+'" value="'+retenciones_ids+'" />';
                                id_retenciones_por_ids = '<input type="hidden" name="retenciones_por_ids'+detalle+acumulador+'" value="'+retenciones_indi_id+'" />';
                                id_fecha = '<input type="hidden" name="fecha_producto_det'+factura+acumulador+'[]" value="'+fecha_producto_det+'" />';
                                eliminar = '<a id="del_doc2" detalle="'+detalle+'" fac="'+factura+'" monto="'+number_format(retencion_porcentaje, 2, '.','')+'" retencion="'+number_format($("#retencion_porcentaje_actu_"+detalle).val(), 2, '.', '')+'" valor="'+id_correlativo+'" thead="tabla_detalle_comprobante_'+factura+'" tbody="body_detalle_comprobante_'+factura+'" class="icon-trash white" style="margin-right: 5px;cursor:pointer;">&nbsp;</a>';
                                $("#body_detalle_comprobante_"+factura).append(
                                    '<tr id="filatabla_detalle_comprobante_'+factura+id_correlativo+'" >' +
                                    '<td>'+ id_comprobante_reten + id_comprobar + id_factura + comprobante_reten +'</td>'+
                                    '<td>'+ id_codigo_producto + codigo_producto + '</td>' +
                                    '<td>'+ id_descripcion_producto + descripcion_producto + '</td>' +
                                    '<td style="text_aling: rigth;" >$'+ id_total_producto + number_format(total_producto, 2) + '</td>'+
                                    '<td>$'+ id_retencion_porcentaje + number_format(retencion_porcentaje, 2) +'</td>' +
                                    '<td>'+ id_retenciones_ids + id_retenciones_por_ids + retenciones_text + '</td>' +
                                    '<td>'+ id_fecha + fecha_producto_det + '</td>' +
                                    '<td align="center"><div>'+ eliminar+ '</div></td>'+
                                    '</tr>');
                                $("#tabla_detalle_comprobante_"+factura).fadeIn(300);
                                var NC = parseInt($('#contador_comprobante_detall_'+factura).val()) + 1;
                                $('#contador_comprobante_detall_'+factura).val(NC);
                                var porcentaje_acumulado = parseFloat(number_format($("#retencion_porcentaje_acum_"+detalle).val(), 2, '.', ''));
                                var porcentaje_actual = parseFloat(number_format($("#retencion_porcentaje_actu_"+detalle).val(), 2, '.', ''));
                                $("#retencion_porcentaje_acum_"+detalle).val(number_format((porcentaje_acumulado+porcentaje_actual),2,'.',''));
                                $("#retencion_porcentaje_actu_"+detalle).val(number_format(0,2));
                                $("#input_retencion_text_"+detalle).val(0);
                                $("#label_retencion_text_"+detalle).text('$'+number_format(0,2));
                                $("#mostrar_tretencion_div_"+detalle).text('');
                                $("#select_ret_"+detalle+" option").removeAttr('selected');
                                $("#select_ret_"+detalle).select2();
                            }
                        }
                    }
                }
            });
            $('#validar_retencion_'+factura).val(contador_retencion);
            if(nochek == 0){
                mensaje = "Debe seleccionar algún producto para el detalle";
            } else if(repetido != 0){
                mensaje = "El comprobante ya a sido agregado";
            } else if(validar_retencion_total != contador_select_total){
                mensaje = "No ha seleccionado una retención valida";
            } else if(validar_select_total == 0){
                mensaje = "El comprobante no debe estar vacío";
            } else if(validar_fecha == 0){
                mensaje = "Fecha requerida";
            } else if(contador_porcentaje > 0){
                mensaje = "El porcentaje de la retención excede el 100%";
            }
            if(mensaje != ""){
                crear_alerta('error', mensaje);
            } else{
                var CC = parseInt($("#contador_acumulador"+factura).val()) + 1;
                $('#contador_acumulador'+factura).val(CC);
            }
            $("#fec_comprobante").val('');
            $("#num_comprobante").val('');
        } else {
            crear_alerta('error', 'Verifique los campos requeridos');
            return false;
        }
    });

    // BORRAR RETENCIONES
    $('#del_doc2').live('click',function(event){
        event.preventDefault();
        var id_fila = $(this).attr("valor");
        var id_head = $(this).attr("thead");
        var id_body = $(this).attr("tbody");
        var retencion = parseFloat(number_format($(this).attr("retencion"),2,'.',''));
        var monto = parseFloat(number_format($(this).attr("monto"),2,'.',''));
        var factura = $(this).attr("fac");
        var detalle = $(this).attr("detalle");
        $("#fila" + id_head + id_fila).remove();
        var retencion_actual_valid = $('#validar_retencion_'+factura).val();
        $('#validar_retencion_'+factura).val(number_format((retencion_actual_valid - monto),2,'.',''));
        var texto_retencion = $("#dtf_text_retencion_"+factura).text();
        // var input_retencion = parseFloat(number_format($("#dtf_retencion_"+factura).val(),2,'.',''));//////////////
        var porcentaje_acum_retencion = $("#retencion_porcentaje_acum_"+detalle).val();
        // var nueva_retencion = number_format((input_retencion - monto),2,'.','');/////////////////////////
        // $("#dtf_text_retencion_"+factura).text('$'+nueva_retencion);/////////////////////////////////
        // $("#dtf_retencion_"+factura).val(nueva_retencion);///////////////////////////////////////
        $("#retencion_porcentaje_acum_"+detalle).val(number_format((porcentaje_acum_retencion - retencion),2,'.',''));
        // var monto_maximo = parseFloat(number_format($("#dtf_pago_"+factura).attr('monto') ,2,'.',''));////////////////////
        // var retencion_maximo = parseFloat(number_format($("#dtf_pago_"+factura).attr('ret') ,2,'.',''));/////////////////
        // var nueva_retencion = number_format((retencion_maximo-monto),2,'.','');///////////////////////////////////////////
        // $("#dtf_pago_"+factura).attr('ret',nueva_retencion);///////////////////////////
        // $("#dtf_pago_"+factura).attr('max',number_format((monto_maximo- parseFloat(nueva_retencion) ),2,'.',''));//////////////////////
        // if($('#'+id_body).find('tr').length == 0 ){///////////////////////////////////////////
            // $("#"+id_head).css('display','none');
            // $("#"+id_head).css('display','none');
        // }
    }); 

});
//PROCESO PARA APLICAR BACKGROUND A LOS TR QUE SON FACTURAS QUE APLICAN A DOMICILIO
function colorDomicilio(){
     $('.color_tr').each(function(index, row){
        var color = $(this).data('color'); //atributo data-color tiene el color del background
        $(this).parents('tr').css({'background-color': color});//aplico css para el background
    });
}

function cargandoIframe(id_iframe) {
    $('#'+id_iframe).load(function() { 
    setTimeout(function() {
        document.getElementById(id_iframe).contentWindow.print(); //para las nuevas versiones de chrome ejecutar un evento
    }, 200);

    setTimeout(function() { wait.close(); 
    }, 900); 
    });

}