$(document).ready(function() {
    var urlj = url_base_proyecto;
    $("select").select2();

    $(".datePicker").attr('placeholder', "dd-mm-yyyy");
    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $('.datePicker').keypress(function(e){
        e.preventDefault();
        return false;
    });

    $('.productos').on('change', function (e) {
        e.preventDefault();
        var unidad_medida   = $("#slc_unidad_medida").val();
        var categorias      = $("#slc_categorias").val();

        if (unidad_medida == "" || categorias == null) {
            $('#slc_productos').empty();
            $('#slc_productos').select2();
            return false;
        }

        $.ajax({
            dataType: 'json',
            type: 'post',
            data: {unidad_medida: unidad_medida, categorias: categorias},
            url: urlj + 'facturacion/entradas/get_productos_promociones',
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {                
                $('#slc_productos').empty();
                var select = '<option value=""></option>';
                $.each(data, function(key, value) {
                    select += '<option value="'+ value.codigo +'">'+ value.nombre +'</option>';
                });
                $('#slc_productos').html(select);
                $('#slc_productos').select2();
                wait.close();
            }
        });
    });

    $('.rango').on('focusout', function (e) { 
        if ( validar_rango( $(this).attr("id") ) == false) {
            crear_alerta("error","Error","El valor desde debe de ser menor al valor hasta.");
            return false;
        }	
    });

    $("#promocion").validate({		
        ignore: [],               
		rules: {
            codigo: { required:true},
            nombre: { required:true},
			fecha_inicio: { required:true},
			fecha_fin: { required:true},		
			cantidad_desde: { required:true},
            cantidad_hasta: { required:true},
            slc_categorias: { required:true},
            slc_unidad_medida: { required:true},
            slc_productos: { required:true}        
        }, 		
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");		
			$('#'+nombre+'_error').text('Campo requerido');
		},
		submitHandler: function(form) {		
            var precio      = $("#precio").val();
            var porcentaje  = $("#porcentaje").val();
            if (precio == "" && porcentaje == "") {
                crear_alerta("error","Error","Se debe agregar Precio o porcentaje.");
                $('#precio_error').text('Campo requerido');
                $('#porcentaje_error').text('Campo requerido');
                return false;
            }	

            if ( validar_rango() == false) {
                crear_alerta("error","Error","El valor desde debe de ser menor al valor hasta.");
                return false;
            }	

            if (precio != "" && porcentaje != "") {
                crear_alerta("error","Error","Solo se puede agregar precio o solamente porcentaje.");
                return false;
            }	
            wait.start();
			form.submit();
		}
    });        
    
    function validar_rango(id = ""){        
        var desde       = $("#cantidad_desde").val(); 
        var hasta       = $("#cantidad_hasta").val(); 
        var resultado   = true;

        if ( desde != "" && hasta != "") {
            if ( parseFloat(desde) > parseFloat(hasta) ) {
                resultado = false;
                if ( id != "" ) {
                    $("#"+id).val("");
                }
            }
        }        
        return resultado;
    }

});
