$(document).ready(function() {

	var pathArray = window.location.pathname.split( '/' );
	var urlj=url_base_proyecto;

	$("select").select2();

	// Array de Meses
	var meses = {'Enero': 1, 'Febrero': 2, 'Marzo': 3, 'Abril': 4, 'Mayo': 5, 'Junio': 6, 'Julio': 7, 'Agosto': 8, 'Septiembre': 9, 'Octubre': 10, 	'Noviembre': 11, 'Diciembre': 12};

    $(".input-fecha").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'MM-yy',
        onClose: function(dateText, inst) { 
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    // Ocultar el calendario para solo mostrar el mes
    $(".input-fecha").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });

    $("#frm_nuevo_caja").validate({
		ignore:"",
		rules: {
			
			caja_nombre: { required:true},
            slcSucursal: { required:true},
			caja_estado: { required:true },
		},  
		  errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			$('#'+nombre+'_error').html(error);
		},
		submitHandler: function(form) {
			var nombre = $("#caja_nombre").val();
			if ($.trim(nombre) != ""){
				form.submit();
			} else {

			}
				
		}
			
	});

	$("body").on("click", "#btn_guardar_metas", function(e) {
		e.preventDefault();
		$("#tbl_metas").DataTable().fnDestroy();
        var mes 	= $("#mes").val();
        var ventas  = ($("#venta_mensual").val() > 0)? parseFloat($("#venta_mensual").val()) : 0;
        var contador = parseInt($("#metas_contador").val());

        // Obtener la fecha
        var mes_split = mes.split('-'); 
        var fecha = mes_split;

        if(validar_campo_repetido((mes), ".metas_validar", "#tb_metas_mensual")){
            crear_alerta("info", "Aviso", 'El registro ya existe.');
            return false;
        }
        if(mes != ""){
            caja_conf = '<input type="hidden" class="metas_validar" value="'+mes+'">';

            caj_mes = '<input type="hidden" id="metas_mes'+contador+'" name="metas_mes[]" value="'+mes+'">'+
            		  '<input type="hidden" id="metas_fecha_'+contador+'" name="metas_fecha_[]" value="'+fecha[1]+'-'+meses[fecha[0]]+'">'+
                      '<label style="padding: 6px 4px;">'+mes+'</label>';

			caj_meta_venta = '<input type="hidden" id="metas_venta'+contador+'" name="metas_venta[]" value="'+ventas+'">'+
                             '<label style="padding: 6px 4px;">$'+number_format(ventas, 2)+'</label>'; 

            eliminar = '<a class="btn btn-danger minia-icon-trashcan white remover_tr action" title="Eliminar Meta" style="margin-right: 5px;cursor:pointer;font-size:15px;">Eliminar</a>';
            caj_acciones = eliminar;

            $("#tb_metas_mensual").append('<tr id="metas_tr'+contador+'" class="metas_tr">'+
                '<td width="10%">'+(contador)+'</td>'+
                '<td width="30%">'+caja_conf + caj_mes+'</td>'+
                '<td width="40%">'+caj_meta_venta+'</td>'+
                '<td width="20%" style="text-align: center;">'+caj_acciones+'</td></tr>');


            contador += 1;
            $("#metas_contador").val(contador);
        } else{
            if(!(mes != "")){
                $("#mes_error").text('Campo requerido.');
            }
        }

        aplicar_datatable("#tbl_metas");
        $("#tbl_metas").css("width", "100%");

	});

	$("body").on('click', ".remover_tr", function(){ //elimina el componente agregado
		$("#tbl_metas").DataTable().fnDestroy();
        var tr = $(this).closest('tr');
        tr.remove();
        aplicar_datatable("#tbl_metas");
        $("#tbl_metas").css("width", "100%");
    });
});

function validar_campo_repetido(valor, campo, padre){
    var validar_unico = false;
    var validacion = $(padre + ' tr input'+campo+'[value="'+valor+'"]').length;
    if(validacion != 0){
        validar_unico = true;
    }
    $("#tbl_metas").css("width", "100%");
    return validar_unico;
}

function aplicar_datatable(id){
    $(id).dataTable({
        //"sPaginationType": "full_numbers",
        "bFilter": false,
        "bJQueryUI": false,
        "bAutoWidth": true,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}