$(document).ready(function () {
    $("#botones").hide();

    $("select").select2({placeholder: "Seleccione un Cliente"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    
    $("body").on('change', '.datePicker', function (e) {
        if ($("#txtFechaIni").val() != "" && $("#txtFechaFin").val() != "") {
            verifica_fecha($("#txtFechaIni").val(), $("#txtFechaFin").val());
        }
    });

    $("#txt_cliente").select2({
        placeholder:'Buscar Cliente',
        minimumInputLength: 3,
        ajax: {
            url:urlj + 'cotizaciones/cotizaciones/get_clientes',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("body").on('change', '#txt_cliente', function (e) {
        var cliente = $("#txt_cliente").val();
        if (cliente > 0) {
            $.ajax({
                type: 'POST',
                url: urlj + 'facturacion/reportes/facturas_padre_cli',
                data:{
                    cliente: cliente
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(datos){
                    $("#factura_cli").html(datos);
                    $("#factura_cli").select2({placeholder: "Seleccione"});
                    wait.close();
                }
            });
        } else {
            $("#factura_cli").html('<option></option>');
            $("#factura_cli").select2({placeholder: "Seleccione un Cliente"});
        }
    });

    $("#chk_mostrar").iButton({
        'labelOn': ' INFORMACIÓN DETALLADA ',
        'labelOff': ' INFORMACIÓN RESUMIDA ',
        'resizeHandle': false,
        change: function (element) {
            if (element.is(':checked')) {
                $('#hdn_mostrar').val(1);
            }else{
                $('#hdn_mostrar').val(0);
            } 
        }
    });

    $("#btnConsultar").click(function(event){
        event.preventDefault();
        $("#botones").hide();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var mostrar = $("#hdn_mostrar").val();
        var cliente = $("#txt_cliente").val();
        var facturas = ($("#factura_cli").val() != null) ? $("#factura_cli").val().toString() : '';
        if (fecha_ini != "" && fecha_fin != "") {
            verifica_fecha(fecha_ini, fecha_fin);
            $("#dv_contenedor_reg").hide('slide', { direction: 'right' }, 400, function(){
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: urlj + 'facturacion/reportes/detalle_notas_remision/1',
                    data:{
                        fecha_ini: fecha_ini,
                        fecha_fin: fecha_fin,
                        ver_version: mostrar,
                        cliente_id: cliente,
                        cli_facturas: facturas,
                        tipo_reporte: ""
                    },
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(result){
                        $("#dv_contenedor_reg").html(result.html);
                        if (result.filas > 0) {
                            $("#botones").show();
                            $("#fecha_ini").val(fecha_ini);
                            $("#fecha_fin").val(fecha_fin);
                            $("#ver_version").val(mostrar);
                            $("#cliente_id").val(cliente);
                            $("#cli_facturas").val(facturas);
                        }
                        $("#dv_contenedor_reg").show("slide", { direction: 'left' }, 500);
                        wait.close();
                    }
                });
            });
        } else {
            crear_alerta('error', 'Atención', 'Verifique las fechas del período');
            return false;
        }
    });   

});

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").val("");
        crear_alerta('error', 'Atención', 'Verifique las fechas del período');
        return false;
    } else {
        return true;
    }
}