$(document).ready(function () {
     
  $(".datePicker").datepicker({
      showButtonPanel: true,
      changeMonth: true,
      changeYear: true,
      dateFormat: 'dd-mm-yy',
      monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
      dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
      nextText: "Siguiente",
      prevText: "Anterior",
      closeText: 'Cerrar',
      currentText: 'Hoy'
   });
  $(".datePicker").mask("99-99-9999");
  
  var dateToday = new Date(); 
  $(".fecha_vencimiento").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        minDate: dateToday,
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
   $(".fecha_vencimiento").mask("99-99-9999");     
   $("#slcEstado").select2();
    
    /*Busqueda*/
   $("#btnConsultar").click(function(){
       var fecha_ini = $("#txtFechaIni").val();
       var fecha_fin = $("#txtFechaFin").val();
       var estado = $("#slcEstado").val();
       
       if(fecha_ini !='' && fecha_fin != ''){
           if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Descuentos','Verifique las fechas del período.');
               return false;
           }
       }

       $("#dv_contenedor_comprobante").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('facturacion/facturar/comprobante_descuento'),
                   data:{fecha_ini:fecha_ini,fecha_fin:fecha_fin, estado:estado},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       wait.close();
                       var oTabla = $("#tblComprobante").dataTable();
                       
                       oTabla.fnDestroy();
                       $("#tbContenedorComprobante").html(result);
                       
                       $("#dv_contenedor_comprobante").show("slide", {
			                    direction: 'left'
                        }, 500);
                       aplidarDataTable('tblComprobante');
                   }
                });
            }
        );
   });

  $(".duplicar").live('click', function(event) {
    var id = $(this).data('id');
    $("#id_cmd").val(id);
  });

  //aplidarDataTable('tblComprobante');

  $("#tblComprobante").on('change', '.comprobante_check', function(event){
    event.preventDefault();
    if ($(this).attr('checked')) {
        $(this).parent().parent().addClass('success');
    } else {
        $(this).parent().parent().removeClass('success');
    }

    if($("#tbContenedorComprobante tr").hasClass('success')){
      $("#imprimir_comp").removeAttr('disabled');
    }else{
      $("#imprimir_comp").attr('disabled', 'disabled');
    }

  });

  $("#tblComprobante").on('change', '#seleccionar_todo', function(event) {
    event.preventDefault();
    wait.start();
      if ($(this).attr('checked')) {
          $(".comprobante_check").attr('checked', true);
          $("#tbContenedorComprobante tr").addClass('success');  
      } else {
          $(".comprobante_check").removeAttr('checked');
          $("#tbContenedorComprobante tr").removeClass('success');
      }
      
      if($("#tbContenedorComprobante tr").hasClass('success')){
        $("#imprimir_comp").removeAttr('disabled');
      }else{
        $("#imprimir_comp").attr('disabled', 'disabled');
      }
    wait.close();
  });

  $("#.eliminar").fancybox({
      width: '75%',
      height: 'auto',
      autoSize: false,
      closeClick: false,
      type: 'inline'
  });

  $("body").on('click', '.eliminar', function(event) {
      event.preventDefault();
      var id = $(this).data("id");
      $("#idcomprobante").val(id);
  });

  $("body").on("click", "#btnAnular", function(e) {
    e.preventDefault();
    if ($.trim($("#motivo").val()) != "") {
      $("#frm_anulacion").submit();
    } else {
      crear_alerta("error", "Anulacion de Comprobante", "Debe ingresar motivo de anulacion de comprobante.");
      return false;
    }
  });
  
  $("body").on("click", "#btnDuplicar", function() {
      alerta_confirm_ajax(duplicar_comprobante, null, "Duplicar Comprobante", "¿Esta seguro que desea duplicar el comprobante?");
  });
    
});

 function duplicar_comprobante() {
        id_cmd      = $("#id_cmd").val();
        fecha       = $("#txtFechaVen").val();
        cantidad    = $("#txtCantidad").val();
        destinatario= $("#txtDestinatario").val();
        descripcion = $("#txtDescripcion").val();

        if(fecha!='' && parseFloat(cantidad)>0){
          wait.start('Espere un momento...procesando la información');
          $.ajax({
              type: 'POST',
              dataType: 'json',
              url: window.gSateliteWhite.baseUrl('facturacion/facturar/duplicar_comprobante'),
              data: {id_cmd: id_cmd, fecha: fecha, cantidad: cantidad, destinatario: destinatario, descripcion: descripcion},
              success: function (data) {
                  if (data.exito > 0) {
                      location.reload();
                  } else {
                      wait.close();
                      crear_alerta('error', 'Error', 'Ocurrió un error al duplicar la(s) comprobante(s)<br>Verificar que la cantidad sea mayor a cero <br> * Favor intentarlo de nuevo');
                  }
              }
          });
        }else{
          crear_alerta('error','Campos requeridos', 'Debe llenar los campos requeridos.');
        }
    }

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "bAutoWidth": false,
        "bPaginate": false,
        "aoColumnDefs": [
          { 'bSortable': false, 'aTargets': [ 0, 6 ] } //que no se pueda ordenar por la columna que posee el checkboX y el textarea
        ],
        "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                  /* Disable initial sort */
        "aaSorting": [], //quitar el orden por defecto

        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });

}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        crear_alerta('error', 'Fechas', "Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}

