jQuery(document).ready(function ($) {

    $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder', "dd-mm-yyyy");
    $("#cliente, #tipo_cliente").select2();
    $("#cliente option[value='0']").val('');

    $("#procesar").click(function (event) {
        fecha_ini = $("#fecha_ini").val();
        fecha_fin = $("#fecha_fin").val();
        cliente = $("#cliente").val();
        documento = $("#documento").val();
        if (fecha_ini == '') {
            $("#fecha_ini").addClass('error');
            $("#fecha_ini_error").text("Campo requerido");
            return false;
        }

        if (fecha_fin == '') {
            $("#fecha_fin").addClass('error');
            $("#fecha_fin_error").text("Campo requerido");
            return false;
        }

        verifica_fecha(fecha_ini, fecha_fin);

        if (fecha_ini != '' && fecha_fin != '') {
            if (!verifica_fecha(fecha_ini, fecha_fin)) {
                return false;
            } else {

                event.preventDefault();
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'facturacion/facturar/facturas_detalle',
                    data: {fecha_ini: fecha_ini, fecha_fin: fecha_fin, cliente: cliente, documento: documento},
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        wait.close();
                        var resp = data.resultado;
                        var tipo = data.tipo;
                        var disp = data.disp;

                        if (resp == 0 && tipo != '' && disp == 0) {
                            crear_alerta('error', 'Proceso fallido', 'No hay correlativos disponibles para las facturas de ' + tipo);
                            wait.close();
                        } else if (resp == 0 && tipo != '' && disp == 1) {
                            crear_alerta('error', 'Proceso fallido', 'No hay correlativos suficientes para las facturas de ' + tipo);
                            wait.close();
                        } else if (resp != 0) {
                            wait.close();
                            $("#contenedorTabla").html(resp);
                            $("#contenedorTabla").show('slide');
                            crear_alerta('info', 'Proceso exitoso', 'La información fue procesada con éxito');
                        }
                    }
                });
            }
        }
    });

    $("#fecha_ini").change(function (event) {
        $("#fecha_ini").removeClass('error');
        $("#fecha_ini_error").text('');
    });
    $("#fecha_fin").change(function (event) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
    });


    function verifica_fecha(fecha_ini, fecha_fin) {
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        // var f1 = new Date(fecha_i);
        // var f2 = new Date(fecha_f);

        if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
            $("#fecha_fin_error").text('');
            return true;
        }

        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            //crear_alerta('error','Error','Verifique las fechas del período');
            $("#fecha_fin").addClass('error');
            $("#fecha_fin_error").text("Verifique las fechas del período");
            return false;
        }

        if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
            $("#fecha_fin").removeClass('error');
            $("#fecha_fin_error").text('');
            return true;
        }
    }


});