$(document).ready(function($) {
    $("select").select2();

    $("#dtg_cliente").select2({
        placeholder:'Seleccione',
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo + " - " + item.nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#dtg_cliente").on('change', function(){
        if($(this).val() > 0){
            $('#factura').select2('enable');
        }else{
            $('#factura').val(null).trigger('change');
            $('#factura').select2('disable');
        }
    });

    $("#factura").select2({
        placeholder: "Buscar Nota de Remisión",
        minimumInputLength: 1,
        ajax: {
            url: urlj + 'facturacion/facturar/get_facturas_like_remision/1',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (factura) {
                var cliente = $('#dtg_cliente').val();
                if (!(cliente != '')) {
                    $('#factura').select2('close');
                    crear_alerta('error','Atención','Primero debe seleccionar el cliente');
                    return false;
                }
                return {
                    factura: factura,
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    var formattedDate = new Date(item.fac_fecha_fact);
                    var d = formattedDate.getDate();
                    var m =  formattedDate.getMonth();
                    m += 1;  
                    var y = formattedDate.getFullYear();
                    var fecha = d + "-" + m + "-" + y;
                    myResults.push({
                        'id': item.fac_id,
                        'text': item.tif_nombre + ' - Doc #' + item.fac_numero + ' - Fecha Doc : ' + fecha
                    });
                });
                return {
                    results: myResults
                };

            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });



    $("#buscar_factura").click(function(event){
        cliente = $("#dtg_cliente").val();
        factura = $("#factura").val();
        if(cliente != "" && cliente > 0  && factura != "" && factura > 0){
            $.ajax({
 	   			dataType: 'json',
 	   			type:'POST',
 	   			url: urlj+'facturacion/facturar/busqueda_factura',
 	   			data: {
                    cliente: cliente,
                    factura: factura
                },
 	   			beforeSend: function(){
 	   			 		wait.start();
 	   			},
 	   			success: function(data){
 	   				wait.close();
 	   				info= data.drop;
 	   				msg=data.titulo_alerta;
                    if($("#tabla_fac").length){
                      var numero1= $("#num_fac").text();
                      var numero2= $("#n_fac").val();
                   
                        if(numero1 != numero2){
                            $("#factura_n").val(factura);
                            $("#tabla_fac, #tabla_detalle, #contenedor_detalles, #extra_info").remove();
                            $("#tabla_facturacion").append(info);
                            if(data != '' ) {
                                $(".principal").show("slide", { direction: 'up'}, 500);   
                            }
                            if( msg ) {
                                $(".principal").hide();
                                crear_alerta('error','Anulación de factura','La factura solicitada no esta disponible');
                            }      
                        }
                    }else{
                        $("#tabla_facturacion").append(info);
                        $("#factura_n").val(factura);
                  
                        if(data != '' ) {
                            $(".principal").show("slide", { direction: 'up'}, 500);   
                        }
                        if( msg ) {
                            $(".principal").hide();
                            crear_alerta('error','Anulación de factura','La factura solicitada no esta disponible');
                        }             
                    } 
                    setTimeout(function(){
                        $("#chkAplicaSeguimiento").iButton({
                            'labelOn': ' Si ',
                            'labelOff': ' No ',
                            'resizeHandle': false,
                            'resizeContainer': false,
                            change: function (element) {
                                if (element.is(':checked')) {
                                    $("#txtAplicaSeguimiento").val(1);

                                } else {
                                    $("#txtAplicaSeguimiento").val(0);
                                }
                            }
                        });
                    }, 500)
                }
            }).done(function(){
 			
            });
     	} else {
     		crear_alerta('error', 'Campos Obligatorios', 'Cliente y Nota de Remisión son requeridos');
     	}
    });

});

function procesar(){
    var razon = $('#razon').val();
    var factura = $('#factura_n').val();
    if( razon != ''){
        var objetos = {razon: razon, factura: factura};
        $.ajax({
            url: urlj+'facturacion/facturar/consulta_pago_factura',
            data: { factura: factura, razon: razon },
            type:'post',
            async: false,
            //datatype:'json',
            success:function(data){
                data = data.trim();
                var obj = jQuery.parseJSON( data );
                if(obj.abono_count==1){
                    alerta_confirm_ajax(validar_anulacion, objetos, 'Pago Pendiente', 'La factura tiene pago registrado, desea anularla?');
                }
            }
        });

        $.ajax({
            url: urlj+'facturacion/facturar/consultar_planes_factura',
            data: {factura:factura},
            type:'post',
            async: false,
            //datatype:'json',
            success:function(data){
                data = data.trim();
                if(data=='1'){
                    crear_alerta('error', 'Error de Anulación', 'La factura tiene un plan de pagos asignado');  
                }
                else{
                    $.confirm({
                        text: "¿Seguro que desea anular esta factura?",
                        confirm: function(button) {
                            $('#factura_form').submit();  
                        },
                        cancel: function(button) {

                        },
                        confirmButton: "Aceptar",
                        cancelButton: "Cancelar",
                        post: true,
                        confirmButtonClass: "btn-danger",
                        cancelButtonClass: "btn-default",
                        dialogClass: "modal-dialog modal-lg" 
                    });
                }
            }
        });
    } else { }

    if(razon == ''){
        $('#razon').addClass('error');
        $("#validar_anulacion").text("Campo requerido");
    }
    if($("#persona_autoriza").val() == ''){
        $("#persona_autoriza").addClass('error');
        $("#validar_autorizacion").text("Campo requerido");
    } 
}

function validar_anulacion(objetos) {
    var factura = objetos.factura;
    var razon   = objetos.razon;
    
    $.ajax({
        url: urlj+'facturacion/facturar/anular_pago_factura',
        data: { factura: factura, razon: razon},
        type:'post',
        async: false,
        datatype:'json',
        success:function(data){
            data = data.trim();
            // console.log(data);
        }
    });
}