var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

jQuery(document).ready(function($) {
    $('select').select2();
    $('#desde,#hasta').numeric();

    $("#serie").change(function(event) {
        var serie           = $("#serie").val();
        var caja            = $("#caja").val();
        var cxj             = ($('#cxf').val()>0)?$('#cxf').val():0;

        var corrSerieIniFin = $("#serie option:selected").text().split("-");
        var inicio          = parseInt(corrSerieIniFin[corrSerieIniFin.length-2]);
        var fin             = ($.isNumeric(corrSerieIniFin[corrSerieIniFin.length-1])) ? parseInt(corrSerieIniFin[corrSerieIniFin.length-1]) : -1;
        var condicion       = null;
        var tipoFactura     = null;

        $.ajax({
            type: "POST",
            dataType:'json',
            async: false,
            url: urlj+'facturacion/entradas/validar_correlativo_cajaxfactura',
            data: {
                inicio:inicio, 
                fin:fin, 
                serie:serie, 
                caja:caja,
                cxj:cxj
            },
            success: function(data){
                if(data.resultado == 0) {
                    inicio  = parseInt(data.inicio);
                    fin     = parseInt(data.fin);
                    if (inicio === fin) {
                        crear_alerta('error', 'Error', 'Tienes Agotado los correlativos de la caja, selecciona otra serie');
                        // var select = $('#serie');
                        // select.val($('option:first', select).val());
                        condicion = data.resultado;
                    } else {
                        crear_alerta('error', 'Error', 'Tienes Agotado los correlativos de la caja, puedes asignar los siguientes '+(inicio+1)+' hasta '+data.fin);
                        condicion = data.resultado;
                    }
                }
            }
        });
        if (condicion == 0) {
            return false;
        }
        $.ajax({
            type: "POST",
            dataType:'json',
            url: urlj+'facturacion/entradas/validar_serie',
            data: {
                inicio:inicio, 
                fin:fin,
                serie:serie, 
                caja:caja,
                cxj:cxj
            },
            success: function(data){
                console.log(data);
                if(data.resp1 == 1){
                    crear_alerta('error', 'Error', 'Esta caja ya tiene asignado un rango de esta serie');
                    document.getElementById("serie").value = "";
                    $("#div_series_usadas").hide();
                    $('#serie option').removeAttr("selected");
                    $("#serie").select2();
                    return false;
                } else {
                }
                if(data.resp2 == 1){
                    crear_alerta('error', 'Error', 'Esta caja ya tiene asignado mismo tipo de factura');
                    document.getElementById("serie").value = "";
                    $("#div_series_usadas").hide();
                    $('#serie option').removeAttr("selected");
                    $("#serie").select2();
                    return false;
                } else {

                }
                if(data.resp2 == 2){
                    crear_alerta('error', 'Error', 'Tienes Agotado los correlativos para tipo de factura '+(data.tipo_factura)+', Selecciona un nuevo rango.');
                    return false;
                } else {
                }
                $("#serie_usadas").select2('destroy');
                $("#serie_usadas").html(data.corre_usa);
                $("#serie_usadas").select2();
                $("#div_series_usadas").show();
            }
        });
    });

    $("#correlativo").validate({
        ignore:"",
        ignore: 'input[type="hidden"]', 
        rules: {
            serie: {required:true, min:1},
            desde: {required:true},
            hasta: {
                required: function (element) {
                    if ($("#par_fact_elect").val() != 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }, 
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#'+nombre+'_error').html(error);
        },
        submitHandler: function(form) {
            var desde = parseInt($("#desde").val());
            var hasta = parseInt($("#hasta").val());
            if(hasta < desde){
                crear_alerta('error','Correlativos','Debe ingresar un rango válido');
                return false;
            }
            form.submit();
        }
    }); 

    $("#frm-correlativo_edit").validate({
        ignore:"",
        rules: {
            serie:{required:true, min:1},
            desde: {required:true},
            hasta:{
                required: function (element) {
                    if ($("#par_fact_elect").val() != 1) {
                        return true;
                    } else {
                        return false;
                    }
                },
                min: function (element) {
                        if ($("#par_fact_elect").val() != 1) {
                            return 1;
                        } else {
                            return -1;
                        }
                    }
                },
        },
        //ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html(error);
        },
        submitHandler: function(form) {
            var desde = $("#desde").val();
            var hasta = $("#hasta").val();
            var state = $("#slcestado").val();
            if(parseInt(hasta) < parseInt(desde)){
                crear_alerta('error','Correlativos','Debe ingresar un rango válido');
                return false;
            }
            if ($.trim(state) == "") {
                wait.close();
                crear_alerta('error','Estado','Debe seleccionar un estado válido');
                return false;   
            }
            form.submit();
        }
    });

    $("#guardar,#guardar_volver").click(function(){
        validar_correlativo(); 
    })

    if($("#edicion").length > 0){
        $("#serie").select2('disable');
        if ($("#disponibles").val() <= 0) {
            $("#slcestado").select2('disable');
        }
    }

    $("body").on("click", ".enviar_edicion", function(){
        wait.start();
        validar_correlativos_usado();
    })

}); // END jQuery

function validar_correlativo(){
    if ($("#desde").val() != '' || $("#hasta").val()!='') {
        var desde = $("#desde").val();
        var hasta = $("#hasta").val();
        var caja = $("#caja").val();
        var serie = $("#serie").val();
        if ( ($("#desde").val() !='' && $("#hasta").val() !='') || $("#par_fact_elect").val() == 1 && $("#desde").val()){
            $.ajax({
                type: "POST",
                dataType:'json',
                url: urlj+'facturacion/entradas/validar_correlativo',
                data: {
                    desde:  desde, 
                    caja: caja, 
                    hasta: hasta, 
                    serie:serie
                },
                success: function(data){
                    if(data.resp==1){
                        crear_alerta('error', 'Error', 'Rango no permitido');
                        document.getElementById("desde").value="";
                        $("#hasta").val('');
                    }else{
                        if($("#correlativo").valid()) {
                            $("#correlativo").submit();
                        }
                    }
                }
            });
        }
    }else{
    }
}

function validar_correlativos_usado(){
    var desde = $("#desde").val();
    var hasta = $("#hasta").val();
    var caja = $("#caja").val();
    var serie = $("#serie").val();
    var correlativo = $("#correlativo_id").val();
    var disponibles = ($("#disponibles").length > 0) ? $("#disponibles").val() : 0;
    if (desde != '' && hasta != '') {
        $.ajax({
            type: "POST",
            dataType:'json',
            url: urlj+'facturacion/entradas/validar_correlativos_usado',
            data: {desde:  desde, caja:caja, hasta:hasta, serie:serie, correlativo: correlativo},
            success: function(data){
                // data.caso: 1-> desde != inicio_actual | 2-> ultimo usado >= hasta_actual | 3-> ultimo disponible pero no es el hasta_actual
                // console.log( data.caso == 2 && disponibles == 0);// se uso el ultimo pero hubo saltos en el correlativo
                // console.log( data.caso == 2 );
                // console.log( data.caso != 2 );
                if(data.resp==1){
                    crear_alerta('error', 'Error', 'Rango no permitido');
                    document.getElementById("desde").value="";
                    $("#hasta").val('');
                    $("#closeser").val(0);
                    wait.close();
                }else{
                    if(data.numero_valido == 1 && ((data.caso == 2 && disponibles == 0) || data.caso != 2) ){
                        crear_alerta('error', 'Error', 'Rango no permitido.');
                        $("#hasta").val('');
                        wait.close();
                    } else{
                        $("#closeser").val(data.numero_valido);
                        if($("#frm-correlativo_edit").valid()) {
                            $("#frm-correlativo_edit").submit();
                        }
                    }
                }
            }
        });
    } else{
        wait.close();
    }

}