jQuery(document).ready(function($) {
	window.gSateliteWhite.jsSelect();

	$(".fecha").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
   $(".fecha").mask("99-99-9999");

  var dateToday = new Date(); 
  $(".fecha_vencimiento").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        minDate: dateToday,
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
   $(".fecha_vencimiento").mask("99-99-9999");   

   // $("#slcCliente").change(function(event) {
   //    nombre = $("#slcCliente option:selected").text();
   //    arr = nombre.split('-');
   //    $("#txtRemitente").val(arr[1]);
   // });

   $("#crear, #crear_v").live('click', function(event) {
       wait.start();
   });


  $("#frm_comprobante").validate({
        ignore: ".select2-container",
        rules: {
            txtMonto: {required: true, min: 5, max: 1000},
            slcCliente: {required: true, min: 1},
            // txtRemitente: {required: true},
            // txtDestinatario: {required: true},
            txtFechaGen: {required: true},
            txtFechaVen: {required: true},
            slcVendedor: {required: true},
        }, 
        messages: {
            txtMonto : "Campo requerido",
            slcCliente : "Campo requerido",
            txtRemitente : "Campo requerido",
            // txtDestinatario : "Campo requerido",
            txtFechaGen : "Campo requerido",
            txtFechaVen : "Campo requerido",
            slcVendedor: "Campo requerido"
        },
        errorPlacement: function (error, element) {
                wait.close();
                var nombre=$(element).attr("id");
                $('#'+nombre+'_error').text('Campo requerido');	

                var fecha_ini = $("#txtFechaGen").val();
                var fecha_fin = $("#txtFechaVen").val();
                if(fecha_ini!='' && fecha_fin!=''){
                    if(!verifica_fecha(fecha_ini,fecha_fin)){
                      return false; 
                    }
                }
        },
        submitHandler: function(form) {	
            wait.close();
            var fecha_ini = $("#txtFechaGen").val();
            var fecha_fin = $("#txtFechaVen").val();
            if(fecha_ini!='' && fecha_fin!=''){
                if(!verifica_fecha(fecha_ini,fecha_fin)){
                  return false; 
                }else{
                     form.submit();
                }
            }		    
        }
	});

  $("body").on("change", "#slcCliente", function() {
      var cliente_val = $(this).val();
      if (cliente_val > 0) {
        nombre = $("#slcCliente option:selected").text();
        arr = nombre.split('-');
        $("#txtRemitente").val(arr[1]);
        $("#txtDestinatario").val(arr[1]);
      } else {
        $("#txtRemitente").val('');
        $("#txtDestinatario").val('');
      }
  });
  
  $("body").on("keyup, blur", "#txtMonto",  function(e) {
      var monto = $(this).val();
      if (monto < 5) {
          $("#txtMonto_error").text('La cantidad Minima que debe introducir es de $5.00');
      } else if (monto > 1000) {
          $("#txtMonto_error").text('La cantidad Maxima que debe introducir es de $1000.00');
      }
      if (monto >= 5 && monto <= 1000) {
          $("#txtMonto_error").text('');
      }
  });

});//End jQuery


function verifica_fecha(fecha_ini, fecha_fin){
    //Convierto la fecha a Y-m-d
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
    
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
      crear_alerta('error','Error','Verifique las fechas del período');
      return false;
    }

    if(Date.parse(fecha_i) < Date.parse(fecha_f)){
      $("#txtFechaVen_error").text('');
      return true;
    }
}