$(document).ready(function() {
    $("select").select2();

    $("#frm_experiencia").validate({
        rules: {           
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });

    $(document).on('change', '#slc_departamento', function(event) {

        if($("#slc_departamento").val() > 0) {
            $.ajax({
                url: urlj+'expediente_personal/reportes/ajax_municipio',
                type: 'POST',
                data: {departamento: $(this).val()},
                dataType: 'json',
                beforeSend: function () {
                    wait.start('Cargando..');
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    wait.close();
                    // Hasta aqui termine y debo comprobar qe se muestre la tabla
                    $("#slc_municipio").html(json.municipios);
                    $("#slc_municipio").select2();
                }
            });
        } else {
            $("#slc_municipio").html('<option value=""></option>');
            $("#slc_municipio").select2();
        }
    });

    $(document).on('click', '#btnConsultar', function(event) {
        departamento = $("#slc_departamento").val();
        municipio = $("#slc_municipio").val();
        $("#dv_contenedor_Empleados").hide('slide', {
            direction: 'right'
        }, 400, function () {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj+'expediente_personal/reportes/zona_residencia/1',
                data: {
                    departamento:departamento, 
                    municipio:municipio
                },
                success: function(data){
                    var oTable = $('#tblEmpleado').dataTable();
                    oTable.fnDestroy(); 
                    $("#tbContenedorEmpleado").html(data);
                    aplicarDataTable('tblEmpleado');
                    $("#filtro_departamento").val(departamento);
                    $("#filtro_municipio").val(municipio);
                    $("#dv_contenedor_Empleados").show("slide", {
                        direction: 'left'
                    }, 500);
                }
            });
        });
    });

});


function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}