$(document).ready(function(){

    $('select').select2();

    $("#btnConsultar").click(function(){
        event.preventDefault();
        $("#btns_exports").hide();
        var empl   = $("#slc_empleado").val();
        var benf = ($.isArray($("#slc_beneficio").val())) ? $("#slc_beneficio").val().toString() : "";        
        $("#dv_contenedor").hide('slide', {
            direction: 'right'
        }, 400, function () {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('expediente_personal/reportes/imprimir_beneficios_puesto/1'),
                dataType: 'json',
                data: {
                    tipo: "",
                    empleado:empl,
                    beneficio:benf
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();                  
                    var oTable = $('#tabla').dataTable();
                    oTable.fnDestroy(); 
                    $("#tbContenedor").html(result.html);
                    aplicarDataTable('tabla');
                    $("#dv_contenedor").show("slide", {
                        direction: 'left'
                    }, 500);
                    if (result.filas > 0) {
                        $("#btns_exports").show();
                    }
                },
                error:function (xh,text,err) {
                    //  console.log(xh);  
                    //  console.log(text);
                    //  console.log(err);
                    wait.close();                     
                }
            });
        });
    });

    $("#imprimir").mouseover(function(event){
        $("#tipo").val(1);
    });

    $("#imp_excel").mouseover(function(event){
        $("#tipo").val(2);
    });

    $(document).on('change', '#slc_empleado', function(){
        if($(this).val()>0) {
            $("#filtro_empleado").val($(this).val());
        } else {
            $("#filtro_empleado").val("");            
        }
    });

    $(document).on('change', '#slc_beneficio', function(){
        let valores = ($.isArray($(this).val())) ? $(this).val().toString() : "";
        $("#filtro_beneficio").val(valores);        
    });

    $('#tabla').dataTable({"sPaginationType": "full_numbers"});
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}