$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });    
    $(".datePicker").mask("99-99-9999");

    $("#reporte_botones").hide();

    $("#slcProfesion").select2({
        placeholder: "Buscar profesion",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'expediente_personal/reportes/consultar_profesion',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (profesion) {
                return {
                    profesion: profesion
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.profesion,
                        'text': item.nombre_profesion
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        event.preventDefault();
        var fecha_inicio = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var profesion = $("#slcProfesion").val();
        if(fecha_inicio !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_inicio,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('expediente_personal/reportes/reporte_profesiones_num_licencia'),
            type: "post",
            dataType: 'json',
            data: {
                fecha_inicio: fecha_inicio,
                fecha_fin: fecha_fin,
                profesion: profesion,
                tipo_reporte: "" 
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (obj) {
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                $("#reporte_botones").show();
                wait.close();
            }
        });
    });

    $("#imprimir_factura").live("click", function(){

        $("#frm_reporte_profesiones_num_licencia").attr('action','imprimir_reporte_profesiones_num_licencia/')
        var tipo = 'excel';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var categoria = $("#slcProfesion").val();

        if(!$("#frm_reporte_profesiones_num_licencia").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }

        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_profesiones_num_licencia").submit();
    });

    $("#imprimir_factura_pdf").live("click", function(){
        $("#frm_reporte_profesiones_num_licencia").attr('action','imprimir_reporte_profesiones_num_licencia/')
        var tipo = 'pdf';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var categoria = $("#slcProfesion").val();

        if(!$("#frm_reporte_profesiones_num_licencia").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }

        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_profesiones_num_licencia").submit();
    });

    $("#frm_reporte_profesiones_num_licencia").validate({
        rules: {
            txtFechaIni:{ required: false },
            txtFechaFin:{ required: false }
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });

});

function verifica_fecha(fecha_ini, fecha_fin){
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
        crear_alerta('error', 'Atención', 'Verifique las fechas del período');
        return false;
    } else {
        return true;
    }
}

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}