$(document).ready(function () {

    $("select").select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    
    $(".tipo").live('change',function(){
        $("#filtro_tipo").val( $(this).val() );
        $("#filtro_tipo_nombre").val( $("option:selected", this).text() );
    });
    
    $("#reporte").validate({
        rules: {
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var fecha_ini =  $("#txtFechaIni").val();
            var fecha_fin = $("#txtFechaFin").val();
            if (fecha_ini == '' || fecha_fin == '') {
                crear_alerta('error', 'Reporte de ingresos y bajas de personal', 'Fechas son obligatorias.');
                return false;
            }
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Reporte de ingresos y bajas de personal', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val( $("#txtFechaFin").val());            
            if ( $("#filtro_tipo").val() == "") {
                crear_alerta('error', 'Reporte de ingreso de personal', 'Favor seleccione un tipo.');
                return false;
            }
            form.submit();
        }
    });
    
    $("#btnConsultar").click(function(){
        event.preventDefault();
        var tipo 		= $("#filtro_tipo").val();
        var nombre_tipo	= $("#filtro_tipo_nombre").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var slcEmpresa = $("#slcEmpresa").val();    
        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Reporte de ingreso de personal', 'Fechas son obligatorias.');
            return false;
        }    
        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('error', 'Reporte de ingreso de personal', 'Verifique el período de las fechas.');
            return false;
        }
        if (tipo == "") {
            crear_alerta('error', 'Reporte de ingreso de personal', 'Favor seleccione un tipo.');
            return false;
        }    
        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        }, 400, function () {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('expediente_personal/reportes/reporte_ingreso_bajas/1'),
                data: {tipo: tipo,nombre_tipo:nombre_tipo,
                fecha_ini:fecha_ini,fecha_fin:fecha_fin,slcEmpresa:slcEmpresa},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    var obj = jQuery.parseJSON( result );                             
                    var oTable = $('#tblListado').dataTable();
                    oTable.fnDestroy();
                    $("#tbContenedorListado").html(obj.html);
                    $("#tbFootListado").html(obj.foot);                    
                    aplicarDataTable('tblListado');    
                    $("#dv_contenedor_listado").show("slide", {
                        direction: 'left'
                    }, 500);
                }
            });
        });        
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
    