$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
    
	$(".datePicker").mask("99-99-9999");
    $("#reporte_botones").hide();

    $("#busqueda_area").hide();
    $("#busqueda_contrato").hide();
    $("#busqueda_profesion").hide();
    $("#busqueda_fechas").hide();

    $("#slcBusqueda").select2();

    $("#slcBusqueda").change(function () {
        var busqueda = $(this).val();

        var fechaActual = new Date();

        // Establecer el primer día del mes
        var primerDia = new Date(fechaActual.getFullYear(), fechaActual.getMonth(), 1);

        // Establecer el último día del mes
        var ultimoDia = new Date(fechaActual.getFullYear(), fechaActual.getMonth() + 1, 0);

        var primerDiaFormateado = formatearFecha(primerDia);
        var ultimoDiaFormateado = formatearFecha(ultimoDia);

        $("#txtFechaIni").val(primerDiaFormateado);
        $("#txtFechaFin").val(ultimoDiaFormateado);

        if (busqueda == 1 ) {

            $("#busqueda_area").show();
            $("#busqueda_contrato").hide();
            $("#busqueda_profesion").hide();
            $("#busqueda_fechas").hide();

        } else if (busqueda == 2) {

            $("#busqueda_area").hide();
            $("#busqueda_contrato").show();
            $("#busqueda_profesion").hide();
            $("#busqueda_fechas").hide();

        } else if (busqueda == 4) {

            $("#busqueda_area").hide();
            $("#busqueda_contrato").hide();
            $("#busqueda_profesion").show();
            $("#busqueda_fechas").hide();

        } else if (busqueda == 3 || busqueda == 5) {

            $("#busqueda_area").hide();
            $("#busqueda_contrato").hide();
            $("#busqueda_profesion").hide();
            $("#busqueda_fechas").show();

        } else {

            $("#busqueda_area").hide();
            $("#busqueda_contrato").hide();
            $("#busqueda_profesion").hide();
            $("#busqueda_fechas").hide();

        }
    });

    $("#slcUnidadOrganizativa").select2({
        placeholder: "Buscar Área / Unidad Organizativa",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'expediente_personal/reportes/consultar_area',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.area,
                        'text': item.nombre_area
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcTipoContrato").select2();

    $("#slcProfesion").select2({
        placeholder: "Buscar profesion",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'expediente_personal/reportes/consultar_profesion',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (profesion) {
                return {
                    profesion: profesion
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.profesion,
                        'text': item.nombre_profesion
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        event.preventDefault();
        var busqueda = $("#slcBusqueda").val();
        var area = $("#slcUnidadOrganizativa").val();
        var tipo_contrato = $("#slcTipoContrato").val();
        var profesion = $("#slcProfesion").val();
        var fecha_inicio = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
    
        $.ajax({
            url: window.gSateliteWhite.baseUrl('expediente_personal/reportes/reporte_ficha_empleados_masivo'),
            type: "post",
            dataType: 'json',
            data: {
                filtro_busqueda: busqueda,
                area: area,
                tipo_contrato: tipo_contrato,
                profesion: profesion,
                fecha_inicio: fecha_inicio,
                fecha_fin: fecha_fin,
                tipo_reporte: "" 
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (obj) {
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                $("#reporte_botones").show();
                wait.close();
            }
        });
    });
  
    $("#imprimir_factura_pdf").live("click", function(event){

        event.preventDefault();

        var idsSeleccionados = [];

        $(".empleado_id").each(function() {
            if ($(this).is(':checked')) {
                idsSeleccionados.push($(this).data('emp-id')); 
            }
        });

        if (idsSeleccionados.length > 0) {

            $("#ids").val(idsSeleccionados.join(","));

            $("#frm_rpt_ficha_empleados_masivo").attr('action','imprimir_reporte_ficha_empleados_masivo')
    
            if(!$("#frm_rpt_ficha_empleados_masivo").valid()){
                crear_alerta('error', 'Alerta', 'Campos con * son requeridos.');
                return false;
            }

            $("#frm_rpt_ficha_empleados_masivo").submit();

        } else {

            crear_alerta('error', 'Alerta', 'Debe de seleccionar al menos un empleado');

        }

        
     });

    $("#frm_rpt_ficha_empleados_masivo").validate({
        rules: {
            txtFechaIni:{ required:false },
            txtFechaFin:{ required:false }
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function formatearFecha(fecha) {
    var dia = ("0" + fecha.getDate()).slice(-2); 
    var mes = ("0" + (fecha.getMonth() + 1)).slice(-2);
    var año = fecha.getFullYear();
    return dia + "-" + mes + "-" + año;
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}