$(document).ready(function () {    
    $('#dependencia option[value="0"]').text('');
    $('#dependencia option[value="0"]').val('');
    $('#dependencia').select2({placeholder: 'Seleccione una opción'});
    
    $("#btnConsultar").click(function() {
        var tipoconstruccion = $("#slcTipoConstruccion").val();
        var departamento = $("#slcDepartamento").val();
        var municipio = $("#slcMunicipio").val();

        $("#htipocontruccion").val(tipoconstruccion);
        $('#htipocontrucciontext').val($("#slcTipoConstruccion option:selected").text());
        $("#hdepartamento").val(departamento);
        $('#hdepartamentotext').val($("#slcDepartamento option:selected").text());
        $("#hmunicipio").val(municipio);
        $('#hmunicipiotext').val($("#slcMunicipio option:selected").text());

        $.ajax({
            dataType: 'text',
            type: 'POST',          
            url: urlj + 'expediente_personal/reportes/reporte_empleado_tipo_vivienda/1',
            data: {
                tipoconstruccion: tipoconstruccion, 
                departamento: departamento, 
                municipio: municipio
            },              
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#dv_contenedor_listado").html(data);
                aplidarDataTable('tblListado');
                $("#pdf").css("display", "");
                $("#excel").css("display", "");
                wait.close();            
            }                       
        });
    });
        
    //Aplicar estilo a los select a algunos tab de ficha general
    $("#slcTipoConstruccion, #slcDepartamento, #slcMunicipio").select2();

    $("#slcDepartamento").change(function(event) {
        if ($(this).val() > 0 ) {
            url_ajax = window.satelite.base_url('expediente_personal/empleado/filtrar_municipio_option');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    slcDepartamento: $("#slcDepartamento").val()
                },
                beforeSend: function () {
                    wait.start('Cargando municipios...');
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#slcMunicipio").html(json.options);
                    $("#slcMunicipio").select2();
                    wait.close();
                }
            });
        } else {
            $("#slcMunicipio").html('<option value=""></option>');
            $("#slcMunicipio").select2();
        }
    });
    
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "aaSorting": [],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}