$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
    
	$(".datePicker").mask("99-99-9999");
    $("#reporte_botones").hide();

    $("#slcProfesion").select2({
        placeholder: "Buscar profesión",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'expediente_personal/reportes/consultar_profesion',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (profesion) {
                return {
                    profesion: profesion
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.profesion,
                        'text': item.nombre_profesion
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcArea").select2({
        placeholder: "Buscar Área / Unidad Organizativa",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'expediente_personal/reportes/consultar_area',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.area,
                        'text': item.nombre_area
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcDepartamento").live('change', function(event) {
        departamento = $(this).val();
        if(departamento > 0) {
          
           $.ajax({
                  type: 'POST',
                  dataType: 'json',
                  url:  window.gSateliteWhite.baseUrl('expediente_personal/reportes/ajax_municipio'),
                  data: {departamento: departamento},
                  beforeSend: function(){
                    $("#slcMunicipio").attr("placeholder", "Cargando...");
                    $("#slcMunicipio").select2();
                  },
                  success: function (data) {

                    $("#slcMunicipio").attr("placeholder", "Seleccione");
                    $("#slcMunicipio").html(data.municipios);
                    $("#slcMunicipio").select2();
                     
                  }
              });
        }else{
          $("#slcMunicipio").html('<option value=""></option>')
          $("#slcMunicipio").attr("placeholder", "Seleccione");
          $("#slcMunicipio option:first").attr('selected','selected');
          $("#slcMunicipio").select2();
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        event.preventDefault();
        var enfermedad = $("#slcEnfermedad").val();
        var area = $("#slcArea").val();
        var departamento = $("#slcDepartamento").val();
        var municipio = $("#slcMunicipio").val();
        var profesion = $("#slcProfesion").val();

        $.ajax({
            url: window.gSateliteWhite.baseUrl('expediente_personal/reportes/reporte_detallado_enfermedades_personal'),
            type: "post",
            dataType: 'json',
            data: {
                enfermedad: enfermedad,
                area: area,
                departamento: departamento,
                municipio: municipio,
                profesion: profesion,
                tipo_reporte: "" 
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (obj) {
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                $("#reporte_botones").show();
                wait.close();
            }
        });
    });

    $("#imprimir_factura").live("click", function(){

        $("#frm_reporte_detallado_enfermedades_personal").attr('action','imprimir_reporte_detallado_enfermedades_personal/')
        var tipo = 'excel';
  
        if(!$("#frm_reporte_detallado_enfermedades_personal").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
  
        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_detallado_enfermedades_personal").submit();
  
      })
  
      $("#imprimir_factura_pdf").live("click", function(){

        $("#frm_reporte_detallado_enfermedades_personal").attr('action','imprimir_reporte_detallado_enfermedades_personal/')
        var tipo = 'pdf';
  
        if(!$("#frm_reporte_detallado_enfermedades_personal").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
  
        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_detallado_enfermedades_personal").submit();
      })

    $("#frm_reporte_detallado_enfermedades_personal").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}