$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
    
	$(".datePicker").mask("99-99-9999");
    $("#reporte_botones").hide();

    $("#slcUnidadOrganizativa").select2({
        placeholder: "Buscar Área / Unidad Organizativa",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'expediente_personal/reportes/consultar_area',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (area) {
                return {
                    area: area
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.area,
                        'text': item.nombre_area
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('text');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcEmpleado").select2({
        placeholder: "Buscar Empleada/o",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'expediente_personal/reportes/get_empleados_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empresa) {
                return {
                    empresa: empresa
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.id,
                        'text': item.nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        event.preventDefault();
        var fecha_inicio = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var unidad_organizativa = $("#slcUnidadOrganizativa").val();
        var empleado = $("#slcEmpleado").val();
    
        $.ajax({
            url: window.gSateliteWhite.baseUrl('expediente_personal/reportes/reporte_capacitaciones'),
            type: "post",
            dataType: 'json',
            data: {
                fecha_inicio: fecha_inicio,
                fecha_fin: fecha_fin,
                unidad_organizativa: unidad_organizativa,
                empleado: empleado,
                tipo_reporte: "" 
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (obj) {
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                $("#reporte_botones").show();
                wait.close();
            }
        });
    });

    $("#imprimir_factura").live("click", function(){

        $("#frm_reporte_capacitaciones").attr('action','imprimir_reporte_capacitaciones/')
        var tipo = 'excel';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var unidad_organizativa = $("#slcUnidadOrganizativa").val();
        var empleado = $("#slcEmpleado").val();
  
        if(!$("#frm_reporte_capacitaciones").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
  
        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_capacitaciones").submit();
  
      })
  
      $("#imprimir_factura_pdf").live("click", function(){

        $("#frm_reporte_capacitaciones").attr('action','imprimir_reporte_capacitaciones/')
        var tipo = 'pdf';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var unidad_organizativa = $("#slcUnidadOrganizativa").val();
        var empleado = $("#slcEmpleado").val();
  
        if(!$("#frm_reporte_capacitaciones").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
  
        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_capacitaciones").submit();
      })

    $("#frm_reporte_capacitaciones").validate({
        rules: {
            txtFechaIni:{ required:false },
            txtFechaFin:{ required:false }
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}