$(document).ready(function () {
    $("#txtFechaIni").mask('99-99-9999');
    $("#txtFechaFin").mask('99-99-9999');
    $('#datagried').dataTable({
        "iDisplayLength": 25,
        "bLengthChange": false,
        "bAutoWidth": false
    });
    gSateliteWhite.jsSelect();
    window.gSateliteWhite.jsSelect();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#consultar").click(function (event) {
        event.preventDefault();
        empleado    = $('#slcEmpleado option:selected').val();
        txtFechaIni = $("#txtFechaIni").val();
        txtFechaFin = $("#txtFechaFin").val();
        slcEstado = $("#slcEstado").val();
        if (txtFechaIni != "" && txtFechaFin != "") {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
            crear_alerta('error', 'Reporte de detalle de contratación', 'Verifique el período de las fechas.');
            return false;
            }
        }
        $("#contenedor").hide("slide", { direction: 'right' }, 400, function () {
            $.ajax({
                type: 'post',
                url: urlj + 'expediente_personal/reportes/reporte_detalle_contratacion',
                dataType:'json',
                data:{
                    empleado: empleado,
                    fechai: txtFechaIni,
                    fechaf: txtFechaFin,
                    estado: slcEstado
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $('#hx').show('slow');
                    var oTable = $('#datagried').dataTable();
                    oTable.fnDestroy();
                    $("#contenedor").html(data.html);
                    $("#contenedor").removeAttr('style');
                    $("#contenedor").css("overflow", "auto");
                    $('#datagried').dataTable({
                        "iDisplayLength": 25,
                        "bLengthChange": false,
                        "bAutoWidth": false
                    });
                    $("#exportar").val(1);
                    $('#datagried').css('width', '100%');
                    $('#estado').val(slcEstado);
                    $('#empleado').val(empleado);
                    $('#fechai').val(txtFechaIni);
                    $('#fechaf').val(txtFechaFin);
                }
            });
        });
    });



    $("#reporte").validate({
        rules: {
            exportar: {required: true},
        },
        errorPlacement: function (error, element) {
            crear_alerta('error', 'Error', 'Debe filtrar la información a exportar');
        },
        submitHandler: function (form) {
            exp = $("#exportar").val();
            if (exp > 0) {
                form.submit();
            }
        }
    });

    $("body").on("change", "#txtFechaIni, #txtFechaFin", function(){
        if ($('#txtFechaIni').val() != "" && $('#txtFechaFin').val() != "") {
            if (!(verifica_fecha($('#txtFechaIni').val(), $('#txtFechaFin').val()))) {
                $('#txtFechaFin').val('');
            }
        }        
    });

}); //End jQuery

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}