jQuery(document).ready(function($) {
	
	/*DatePicker*/
	$("input[name^='fecha']").datepicker({
		dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: false
	});
	$("input[name^='fecha']").mask('99-99-9999');

	/*Select2*/
	$('#area, #slcSucursal').select2().select2('val', 0);

	/*Validación*/
	$("#formulario").validate({
		rules: {
			/*area: {
				required:function() {
					return $("#area option:selected").val() != "0"
				}
			},*/
			fecha_desde: "required",
			fecha_hasta: "required"
		},
		messages : {
			/*area : {
				required : "Campo requerido."
			},*/
			fecha_desde : {
				required : "Campo requerido."
			},
			fecha_hasta : {
				required : "Campo requerido."
			},
		},
		ignore: ".select2-container",
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			$('#'+nombre+'_error').html(error);
		},
		submitHandler: function(form) {
			wait.start();
			var desde=$('#fecha_desde').attr('value');
			var hasta=$('#fecha_hasta').attr('value');
			var area=$('#area').attr('value');
			var slcSucursal=$('#slcSucursal').attr('value');
			var slcEmpresa=$('#slcEmpresa').val();
			var url=urlj+'expediente_personal/reportes/obtener_cupleaneros';
			$.ajax({
				url: url,
				type: 'POST',
				dataType: 'JSON',
				data: {
					desde: desde,
					hasta: hasta,
					area: area,
					slcSucursal: slcSucursal,
					slcEmpresa: slcEmpresa
				},
				success: function(json){
					$('#resultados').html(json.html);
					if(Number(json.respuesta)==1){
						$('#excel').attr('disabled', false);
						$('#pdf').attr('disabled', false);
					}else{
						$('#excel').attr('disabled', true);
						$('#pdf').attr('disabled', true);
					}
					wait.close();
				}
			});			
		}
	});


	/*Generales*/
	$('.reporte').click(function(event) {
		event.preventDefault();
		var tipo=$(this).attr('id');
		$("#tipo").val(tipo);
		$("#export_print").submit();
	});

	$("#slcEmpresa").change(function(event) {
		cargar_sucursales();
		cargar_areas();
	});
});

function cargar_sucursales() {
	url_ajax = window.satelite.base_url('expediente_personal/reportes/filtrar_sucursales_option');
	$.ajax({
		url: url_ajax,
		type: 'POST',
		dataType: 'json',
		data: {slcEmpresa: $("#slcEmpresa").val()},
		beforeSend: function () {wait.start('Cargando sucursal...');},
		error: function (xhr, status, error){
			exportarError(xhr.responseText);
			wait.close();
		},
		success: function (json) {
			$("#slcSucursal").html(json.options);
			$("#slcSucursal").select2();
			wait.close();
		}
	});
}

function cargar_areas() {
	url_ajax = window.satelite.base_url('expediente_personal/reportes/filtrar_areas_option');
	$.ajax({
		url: url_ajax,
		type: 'POST',
		dataType: 'json',
		data: {slcEmpresa: $("#slcEmpresa").val()},
		beforeSend: function () {wait.start('Cargando areas...');},
		error: function (xhr, status, error){
			exportarError(xhr.responseText);
			wait.close();
		},
		success: function (json) {
			$("#area").html(json.options);
			$("#area").select2();
			wait.close();
		}
	});
}