jQuery(document).ready(function ($) {
    $('select').select2();

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            slcEmpresa: {required: true, min:1}
        },
        messages: {
            slcEmpresa: "Campo requerido",
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }

        },
        submitHandler: function (form) {
           $("#contenedorTabla").hide("slide", { 
            direction: 'right'
          }, 400, function() { //despues de ocultar div enviar el ajax

              url_ajax = window.satelite.base_url('expediente_personal/empleado/filtrar_retiro_masivo_empleados');
               $.ajax({
                   url: url_ajax,
                   type: 'POST',
                   dataType: 'json',
                   data: {
                       slcEmpresa: $("#slcEmpresa").val(),
                       slcSucursal: $("#slcSucursal").val(),
                       slcArea: $("#slcArea").val()
                   },
                   beforeSend: function () {
                       wait.start();
                   },
                   error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#contenedorTabla").html(json.html);
                    $("#contenedorTabla").show("slide", {
                      direction: 'left'
                    }, 500);
                    wait.close();

                }
            });
        });
       }
   });

  $("#slcEmpresa").change(function(event) {
    cargar_sucursales();
    cargar_areas();
  });

  $("#contenedorTabla").on('change', '.empleado_check', function(event) {
    event.preventDefault();
    if ($(this).attr('checked')) {
        $(this).parent().parent().attr('style', 'background:rgb(249, 193, 189) !important;');
        $("#txtMotivo_" + $(this).val()).removeAttr('disabled');
    } else {
        $(this).parent().parent().removeAttr('style');
        $("#txtMotivo_" + $(this).val()).val('');
        $("#txtMotivo_" + $(this).val()).attr('disabled', true);
    }
    $("#lblNumeroSelec").text('(' + $(".tdCheck input[type='checkbox']:checked").length + ' empleados seleccionados)');
  });

  $("#contenedorTabla").on('change', '#seleccionar_todo', function(event) {
    event.preventDefault();
    wait.start();
      if ($(this).attr('checked')) {
          $(".empleado_check").attr('checked', true);
          $("#contenedor tr").attr('style', 'background:rgb(249, 193, 189) !important;');
          $(".motivo_esp").removeAttr('disabled');
      } else {
          $(".empleado_check").removeAttr('checked');
          $("#contenedor tr").removeAttr('style');
          $("#contenedor tr .motivo_esp").val('');
          $("#contenedor tr .motivo_esp").attr('disabled', true);
      }
      setTimeout(function() {
        $("#lblNumeroSelec").text('(' + $(".tdCheck input[type='checkbox']:checked").length + ' empleados seleccionados)');
      }, 300);
  wait.close();
  });

    $("#btnEnviar").live('click', function(event) {
        event.preventDefault();
        if ($("#slcCategoriaRetiro").val() > 0 && $("#fecha_retiro").val() != "" && $(".tdCheck input[type='checkbox']:checked").length > 0) {
            nr = $(".tdCheck input[type='checkbox']:checked").length ;
            msj = "<b>Nota: </b> - Verificar que no se tenga ningun proceso pendiente contra el empleado";
            msj += "- Una vez dado de baja no podra procesarse en planilla";
            alerta_confirm_ajax(ejecutarSubmit,'',"Esta seguro que desea dar de baja a "+ nr+" empleado(s)?",msj);
        } else {
            crear_alerta('info','Campos requeridos',"Seleccionar la categoria y fecha de retiro y al menos un empleado");
        }
    });




});

function ejecutarSubmit(param) {
  $("#frmEnviar").submit();
}

function cargar_sucursales() {
    url_ajax = window.satelite.base_url('expediente_personal/reportes/filtrar_sucursales_option');
     $.ajax({
         url: url_ajax,
         type: 'POST',
         dataType: 'json',
         data: {
             slcEmpresa: $("#slcEmpresa").val()
         },
         beforeSend: function () {
             wait.start('Cargando sucursal...');
         },
         error: function (xhr, status, error){
          exportarError(xhr.responseText);
          wait.close();
      },
      success: function (json) {
          $("#slcSucursal").html(json.options);
          $("#slcSucursal").select2();
          wait.close();

      }
  });
}

function cargar_areas() {
    url_ajax = window.satelite.base_url('expediente_personal/reportes/filtrar_areas_option');
     $.ajax({
         url: url_ajax,
         type: 'POST',
         dataType: 'json',
         data: {
             slcEmpresa: $("#slcEmpresa").val()
         },
         beforeSend: function () {
             wait.start('Cargando areas...');
         },
         error: function (xhr, status, error){
          exportarError(xhr.responseText);
          wait.close();
      },
      success: function (json) {
          $("#slcArea").html(json.options);
          $("#slcArea").select2();
          wait.close();
      }
  });
}