$(document).ready(function(){
	window.gSateliteWhite.jsSelect();

	$(".uploader").attr('title', 'Seleccione un archivo CSV');
	$(".uploader").tooltip();
	$(".oculto").hide();
	$(".ayuda").click(function(event) {
		html=$("#div_ayuda").html();
		$.fancybox(html,{title:'FORMATO CSV PARA SER PROCESADO'});
	});



	$("#cargar_pre").on('click',function(){
		$("#contenedor_info").html('');
		$("#contenedor_resultado_ex, .oculto").hide();
		var file_data = $('#csv_insumos').prop('files')[0];   
		var form_data = new FormData();                  
		form_data.append('csv_insumos', file_data);

		if(validar_archivo()){
			$.ajax({
				dataType:'json',
				type:'post',
				cache: false,
				contentType: false,
				processData: false,
				data: form_data,
				
				url: window.satelite.base_url('expediente_personal/empleado/carga_masiva_insumo'),
				beforeSend: function(){
					wait.start();
				},
				success: function(data){
					wait.close();
					$("#csv_insumos").val('');
					$("#ciclico_nombre").val(data.nombre);
					$("#ciclico_ruta").val(data.ruta);
					$(".filename").text("No file selected");
					if(data.drop == ''){
						crear_alerta("success","Éxito","Carga de datos realizada con éxito");
					} else {
						$("#contenedor_info").html(data.drop);
						$("#contenedor_resultado_ex, .oculto").show("slide");
					}
					
				}
			})
		}
	});


$("body").on('click', '.eliminar_fila', function(event) {
	event.preventDefault();
	$(this).parent().parent().remove();
	$("#cantidad_registro").val($("#contenedor .reg_correcto").length);
});


$("#cancelar").click(function(event){
	alerta_confirm_ajax(regresar,1,'Confirmar eliminar registro','Los datos cargados aun no han sido guardados. ¿Éstas seguro que desea cancelar el proceso?');
});

 $("#form_vista_csv").validate({
     ignore: "",
     rules: {
         cantida_registro: {required: true, min:1}
     },
     messages: {
         cantida_registro: "Debe existir al menos un registro para ser procesado"
     },
     ignore: ".select2-container",
     errorPlacement: function (error, element) {
         if (element.is('select'))
         {
             $(element).next().append(error);
         }
         else
         {
             error.insertAfter(element);
         }

        //$("[for=txtFecha_desde]").css("margin-left", "17%");
        //$("[for=txtFecha_hasta]").css("margin-left", "17%");

     },
     submitHandler: function (form) {
     	 wait.start();
	     form.submit();
    }
});


});


function regresar(data) {
	window.location.href = window.satelite.base_url('expediente_personal/empleado/carga_masiva_insumo');
}


function validar_archivo() {

	valor = $("#csv_insumos").val();
	if(valor!="") {

		extension = (valor.substring(valor.lastIndexOf("."))).toLowerCase(); 
		if(extension=='.csv'){
			return true;
		} else {
			$("#muestra_error_file").text('Debe ser un archivo con extensión .csv');
			return false;
		}
	}
	else {
		$("#muestra_error_file").text('Archivo con extensión .csv requerido');
		return false;
	}
}


