$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var add = (pathArray.length - 1);
    var edit = (pathArray.length - 2);
    var vista = $("#txtvista").val();
    var dispo = 0;

    if (vista > 0) {
        calcular_disponible(vista);
    }

    $('#field_acn_porcentaje').blur(function () {
        var porcentaje = $('#field_acn_porcentaje').val();
        var disponible = $('#dispo').val();
        if (vista == 1) {
            if (parseFloat(porcentaje) > parseFloat(disponible)) {
                crear_alerta("error", "Atención", "Porcentaje no debe ser mayor a " + disponible + "%");
                $("#field_acn_porcentaje").val('');
            }
        }
        if (vista == 2) {
            var actual = $("#actual").val();
            var total = parseFloat(actual) + parseFloat(disponible);
            console.log(total);
            if (parseFloat(porcentaje) > parseFloat(total)) {
                if (disponible > 0) {
                    crear_alerta("error", "Atención", "Nuevo porcentaje no debe ser mayor a " + total + "%");
                } else {
                    crear_alerta("error", "Verifique", "No existe porcentaje disponible");
                }
                $("#field_acn_porcentaje").val('');
            }
        }
    });

    $('.validar_miles').blur(function () {
        var monto = $(this).val();
        var dec = $(this).data('dec');
        if ($.trim(monto) != "") {
            var final = number_format(monto,dec,'.','');
            $(this).val(final);
        }
    });

    $('#save-button').click(function () {
        setTimeout(function () {
            calcular_disponible(vista);
            if (vista == 2) {
                $("#actual").val($('#field_acn_porcentaje').val());
                console.log('exito');
            }
        }, 500);
    });

    $('select').select2({
        placeholder: 'Seleccione una opción'
    });
    $(".telefonoMask").mask('9999-9999');
    $("#txtdui").mask('99999999-9');
    $("#txtnit").mask('9999-999999-999-9');
    $(".telefono").mask('9999-9999');
    $(".fecha").mask('99-99-9999');

    aplicarDatePicker(".fecha",false);

    $("#frm-proveedor").validate({
        ignore: [],
        rules: {
            txttitular: {required: true},
            acn_porcentaje: {required: true},
            slctitular: { required: true },
            slcintitucion: { required: true }
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            // var contar_porcentajes = 0;
            // if ($("#tbl_contenedor_finanzas .tr_finanzas").length > 0) {
            //     $("#tbl_contenedor_finanzas .tr_finanzas").each(function () {            
            //         var id_centro = $(this).attr("id");
            //         contar_porcentajes = contar_porcentajes + parseFloat( $("#txt_porcentaje_finanza_"+id_centro).val() );
            //     });               
            //     if (contar_porcentajes != 100) {
            //         crear_alerta('error', 'Finanzas', 'La sumatoria de porcentajes debe ser 100.');
            //         $("#pes-finanzas").click();
            //         return false;
            //     }
            // }
            if (verifica_fecha($("#txtperiodoD").val(), $("#txtperiodoH").val())) {
                wait.start();
                form.submit();
            } else {
                console.log("exito");
            }
        }
    });

    $("#BtnLogro").click(function () {
        var nombre = $("#txtasistente").val();
        var telefono = $("#txttelefonoA").val();
        var row_as = $("#asist_filas").val();
        if (nombre != '' && telefono != '') {
            var html = '<tr id="fila_'+row_as+'">';
            html += '<input type="hidden" class="asa_id" name="asa_id[]" value="0" >';
            html += '<td>';
            html += '<label class="lb_asis_nom">' + nombre + '</label>';
            html += '<input type="hidden" class="txt_asis_nom" name="txtasistente[]" value="' + nombre +'" >';
            html += '</td>';
            html += '<td>';
            html += '<label class="lb_asis_tel">' + telefono + '</label>';
            html += '<input type="hidden" class="txt_asis_tel" name="txttelefonoA[]" value="' + telefono + '" >';
            html += '</td>';
            html += '<td>';
            html += '<button type="button" data-id="'+row_as+'" class="btn btn-danger btn-mini btnDelCompe" style="float:left; height:30px;width:50px;">Eliminar</button>';
            html += '</td>';
            $("#tbContenedorLogros").append(html);
            $("#txtasistente").val('');
            $("#txttelefonoA").val('');
            row_as++;
            $("#asist_filas").val(row_as);
        } else {
            crear_alerta('error', 'Detalle asistente', 'Debe llenar los campos para agregar detalle.');
        }
        
    });
    $('.btnDelCompe').live('click',function(event){
        var id = $(this).data("id");
        $("#fila_"+id).remove();
    });

}); //fin del document ready


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function aplicarDatePicker(idCampo, destruir) {

    if (destruir) {
        $(idCampo).datepicker('destroy');
    } else {
        $(idCampo).datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
                    //minDate: 0
        });
    }
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        //$("#fecha_fin_error").text('');
        $("#txtperiodoD").removeClass('error');
        $("#txtperiodoH").removeClass('error');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtperiodoD").addClass('error');
        $("#txtperiodoH").addClass('error');
        //$("#fecha_fin_error").text("Verifique las fechas del período");
        crear_alerta("error", "Verifique", "Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#txtperiodoD").removeClass('error');
        $("#txtperiodoH").removeClass('error');
        //$("#fecha_fin_error").text('');
        return true;
    }

    return true;
}

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }

        opciones += this.outerHTML;
    });

    return opciones;
}

function aplicarSelect2(selector) {
    $(selector).select2({
        placeholder: 'Seleccione una opción'
    });
}

function calcular_disponible(vista) {
    $("#notificacion").html('');
    $.ajax({
        type: 'POST',
        url: window.gSateliteWhite.baseUrl('estructura_organizativa/procesos/get_porcentaje_disponible'),
        dataType: 'json',
        data: {
            vista: vista
        },
        beforeSend: function () {
            wait.start();
        },
        success: function (data) {
            console.log(data);
            if (vista == 1) { $("#notificacion").append('<span id="disponible"><b>Porcentaje disponible: ' + data.disponible.toFixed(2) + '%</b></span>'); }
            if (vista == 2) { $("#notificacion").append('<span id="disponible"><b>Porcentaje adicional disponible: ' + data.disponible.toFixed(2) + '%</b></span>'); }
            $('#dispo').val(data.disponible);
            wait.close();
        }
    });
}
    