$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    var error_encontrado = false;
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({
        placeholder: 'Seleccione una opción'
    });
    $('.select-edit').select2('destroy');
    $('.select-edit').hide();
    $(".telefonoMask").mask('9999-9999');

    $("#chkStaff, #chkDibujar").iButton({
        'resizeHandle': false,
        'resizeContainer': false,
        'labelOn': 'Si',
        'labelOff': 'No'
    });

    $("#pes-horarios").click(function () {
        setTimeout(function () {
            $("#chkPagoHorasExt").iButton({
                'labelOn': 'Si',
                'labelOff': 'No',
                'resizeHandle': false,
                'resizeContainer': false,
                change: function (element) {
                    if (element.is(':checked')) {
                        $("#hdnPagoHorasExt").val(1);
                    } else {
                        $("#hdnPagoHorasExt").val(0);
                    }
                }
            });
        }, 300);
    });

    $("#txtFechaVencimiento,#txtFechaExpedicion").datepicker('destroy');
    $("#txtFechaVencimiento,#txtFechaExpedicion").datepicker('destroy');
    $("#txtFechaVencimiento,#txtFechaExpedicion").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });

    $("#slcPersoneria").change(function () {
        if ($(this).val() == 1) {
            $("#lblNombreProv").html('Nombre:<b style="color:red;">*</b>');
            $("#lblApellidoProv").html('Apellido:<b style="color:red;">*</b>');
        } else {
            $("#lblNombreProv").html('R. Comercial:<b style="color:red;">*</b>');
            $("#lblApellidoProv").html('R. Social:<b style="color:red;">*</b>');
        }
    });

    //Limpiando campos de error
    $("input,select").change(function () {
        var elemento = $(this);
        $("#" + elemento[0].id).removeClass('error');
        var nombre = elemento[0].id;//$("#" + ).attr("id");
        $("#" + nombre + "_error").html('');
    });

    $("input").keyup(function () {
        var elemento = $(this);
        $("#" + elemento[0].id).removeClass('error');
        var nombre = elemento[0].id;//$("#" + ).attr("id");
        $("#" + nombre + "_error").html('');
    });

    $("[name='btnGuardar']").live('click', function () {
        if (verificarValidacion()) {
            $("#frm-proveedor").submit();
        }
    });

    $("#frm-proveedor").validate({
        ignore: [],
        rules: {
            txtNombre: {required: true},
            slcCentroCosto: {required: true},
            slcArea:{required:true, min:1},
            slcestado:{required:true, min:1}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            var contar_porcentajes = 0;
            if ($("#tbl_contenedor_finanzas .tr_finanzas").length > 0) {
                $("#tbl_contenedor_finanzas .tr_finanzas").each(function () {
            
                    var id_centro = $(this).attr("id");
                    contar_porcentajes = contar_porcentajes + parseFloat( $("#txt_porcentaje_finanza_"+id_centro).val() );
                });
               
                if (contar_porcentajes != 100) {
                    crear_alerta('error', 'Finanzas', 'La sumatoria de porcentajes debe ser 100.');
                    $("#pes-finanzas").click();
                    return false;
                }

            }

            //if (verificarValidacion()) {
            form.submit();
            //}
        }
    });


    $(".select-edades").blur(function () {
        verifica_edad();
    });


    $("#mytab .tab-li a").click(function () {
        if (error_encontrado == false) {
            //
            //verificarValidacion();
        } else {
            error_encontrado = false;
        }
        $(this).removeClass('tab-error');
    });

    //Agregar Logros
    var i = 0;

    if ($("#tbContenedorLogros .trLogro").length > 0) {
        i = $("#tbContenedorLogros .trLogro").length + 1;
    }

    $("#BtnLogro").click(function () {
        var slcAreaResultado = $("#slcAreaResultado").val();
        var slcAreaResultadoText = $("#slcAreaResultado option:selected").text();
        var slcAreaResultadoHtml = getOpcionesSelect('slcAreaResultado');
        var slcAreaRespon = $("#slcAreaRespon").val();
        var slcAreaResponText = $("#slcAreaRespon option:selected").text();
        var slcAreaResponHtml = getOpcionesSelect('slcAreaRespon');
        var slcTiempo = $("#slcTiempo").val();
        var slcTiempoText = $("#slcTiempo option:selected").text();
        var slcTiempoHtml = getOpcionesSelect('slcTiempo');

        if (slcAreaResultado > 0 && slcAreaRespon > 0 && slcTiempo > 0) {

            var html = '';
            var idTr = "Logro_" + slcAreaResultado + "_" + slcAreaRespon;

            if ($("#" + idTr).length > 0) {
                crear_alerta('error', 'Logros', 'Estas características ya fueron ingresadas.');
                return false;
            }

            //Se dibuja el html
            var html = '<tr id="' + idTr + '" data-id="' + i + '" class="trLogro">';

            html += '<td>';
            html += '<input type="text" class="text tables-input select-text" value="' + slcAreaResultadoText + '" readonly="readonly"/>';
            html += '<select id="slcAreaResultado_' + i + '" name="areasResultado[]" data-id="' + i + '" style="display:none;" class="select-edit">' + slcAreaResultadoHtml + '</select>';
            html += '</td>';

            html += '<td>';
            html += '<input type="text" class="text tables-input select-text" value="' + slcAreaResponText + '" readonly="readonly"/>';
            html += '<select id="slcAreaRespon_' + i + '" name="areasResponsable[]" data-id="' + i + '" style="display:none;" class="select-edit">' + slcAreaResponHtml + '</select>';
            html += '</td>';

            html += '<td>';
            html += '<input type="text" class="text tables-input select-text" value="' + slcTiempoText + '" readonly="readonly"/>';
            html += '<select id="slcAreaResultado_' + i + '" name="tiempoPorc[]" data-id="' + i + '" style="display:none;" class="select-edit">' + slcTiempoHtml + '</select>';
            html += '</td>';

            html += '<td>';
            html += '<button type="button" class="btn btn-primary btn-mini btnGuardarLog" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>'
            html += '<button type="button" class="btn btn-primary btn-mini btnEditLog" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: none;"><input type="hidden" value="6" id="txtest">Editar</button>';
            html += '<button type="button" class="btn btn-danger btn-mini btnDelLog" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
            html += '</td>';

            html += '</tr>';


            $("#tbContenedorLogros").append(html);
            $("#slcAreaResultado option:selected").removeAttr('selected');
            $("#slcAreaRespon option:selected").removeAttr('selected');
            $("#slcTiempo option:selected").removeAttr('selected');

            aplicarSelect2("#slcAreaResultado");
            aplicarSelect2("#slcAreaRespon");
            aplicarSelect2("#slcTiempo");

            i++;
        } else {
            crear_alerta('error', 'Logro(s)', 'Debe completar todos los campos.');
        }
    });

    //Eliminar Logros
    $(".btnDelLog").live("click", function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);
    });


    //Agregar Competencias
    var j = 0;

    if ($("#tbContenedorCompetencias .trCompe").length > 0) {
        j = $("#tbContenedorCompetencias .trCompe").length + 1;
    }

    $("#BtnCompetencia").click(function () {
        var slcCompetencias = $("#slcCompetencias").val();
        var slcCompetenciasText = $("#slcCompetencias option:selected").text();
        var slcCompetenciasHtml = getOpcionesSelect('slcCompetencias');
        var slcClasificacion = $("#slcClasificacion").val();
        var slcClasificacionText = $("#slcClasificacion option:selected").text();
        var slcClasificacionHtml = getOpcionesSelect('slcClasificacion');

        if (slcCompetencias > 0 && slcClasificacion > 0) {

            var html = '';

            var idTr = "Comp_" + slcCompetencias + "_" + slcClasificacion;

            if ($("#" + idTr).length > 0) {
                crear_alerta('error', 'Competencias', 'Estas características ya fueron ingresadas.');
                return false;
            }

            //Se dibuja el html
            var html = '<tr id="' + idTr + '" data-id="' + j + '" class="trCompe">';

            html += '<td>';
            html += '<input type="text" class="text tables-input select-text" value="' + slcCompetenciasText + '" readonly="readonly"/>';
            html += '<select id="slcCompetencias_' + j + '" name="competencias[]" data-id="' + j + '" style="display:none;" class="select-edit">' + slcCompetenciasHtml + '</select>';
            html += '</td>';

            html += '<td>';
            html += '<input type="text" class="text tables-input select-text" value="' + slcClasificacionText + '" readonly="readonly"/>';
            html += '<select id="slcClasificacion_' + j + '" name="clasificaciones[]" data-id="' + j + '" style="display:none;" class="select-edit">' + slcClasificacionHtml + '</select>';
            html += '</td>';

            html += '<td>';
            html += '<button type="button" class="btn btn-primary btn-mini btnGuardarCompe" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>'
            html += '<button type="button" class="btn btn-primary btn-mini btnEditCompe" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: none;"><input type="hidden" value="6" id="txtest">Editar</button>';
            html += '<button type="button" class="btn btn-danger btn-mini btnDelCompe" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
            html += '</td>';

            html += '</tr>';


            $("#tbContenedorCompetencias").append(html);
            $("#slcCompetencias option:selected").removeAttr('selected');
            $("#slcClasificacion option:selected").removeAttr('selected');

            aplicarSelect2("#slcCompetencias");
            aplicarSelect2("#slcClasificacion");

            j++;
        } else {
            crear_alerta('error', 'Competencia(s)', 'Debe completar todos los campos.');
        }
    });

    //Eliminar Competencia
    $(".btnDelCompe").live("click", function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);
    });

    //Agregar Riesgos
    var k = 0;

    if ($("#tbContenedorRiesgos .trRsg").length > 0) {
        k = $("#tbContenedorRiesgos .trRsg").length + 1;
    }

    $("#BtnRiesgo").click(function () {
        var slcTipoRiesgo = $("#slcTipoRiesgo").val();
        var slcTipoRiesgoText = $("#slcTipoRiesgo option:selected").text();
        var slcTipoRiesgoHtml = getOpcionesSelect('slcTipoRiesgo');
        var slcNivelRiesgo = $("#slcNivelRiesgo").val();
        var slcNivelRiesgoText = $("#slcNivelRiesgo option:selected").text();
        var slcNivelRiesgoHtml = getOpcionesSelect('slcNivelRiesgo');

        if (slcTipoRiesgo > 0 && slcNivelRiesgo > 0) {

            var html = '';

            var idTr = "Rsg_" + slcTipoRiesgo;

            if ($("#" + idTr).length > 0) {
                crear_alerta('error', 'Exposiciones a riesgos laborales.', 'Estas características ya fueron ingresadas.');
                return false;
            }

            //Se dibuja el html
            var html = '<tr id="' + idTr + '" data-id="' + k + '" class="trRsg">';

            html += '<td>';
            html += '<input type="text" class="text tables-input select-text" value="' + slcTipoRiesgoText + '" readonly="readonly"/>';
            html += '<select id="slcTipoRiesgo_' + k + '" name="tipos_riesgo[]" data-id="' + k + '" style="display:none;" class="select-edit">' + slcTipoRiesgoHtml + '</select>';
            html += '</td>';

            html += '<td>';
            html += '<input type="text" class="text tables-input select-text" value="' + slcNivelRiesgoText + '" readonly="readonly"/>';
            html += '<select id="slcNivelRiesgo_' + k + '" name="niveles_riesgo[]" data-id="' + k + '" style="display:none;" class="select-edit">' + slcNivelRiesgoHtml + '</select>';
            html += '</td>';

            html += '<td>';
            html += '<button type="button" class="btn btn-primary btn-mini btnGuardarRsg" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>'
            html += '<button type="button" class="btn btn-primary btn-mini btnEditRsg" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: none;"><input type="hidden" value="6" id="txtest">Editar</button>';
            html += '<button type="button" class="btn btn-danger btn-mini btnDelRsg" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
            html += '</td>';

            html += '</tr>';


            $("#tbContenedorRiesgos").append(html);
            $("#slcTipoRiesgo option:selected").removeAttr('selected');
            $("#slcNivelRiesgo option:selected").removeAttr('selected');

            aplicarSelect2("#slcTipoRiesgo");
            aplicarSelect2("#slcNivelRiesgo");

            k++;
        } else {
            crear_alerta('error', 'Exposiciones a riesgos laborales', 'Debe completar todos los campos.');
        }
    });

    //Eliminar Riesgo
    $(".btnDelRsg").live("click", function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);
    });

    //Carpeta de Anexos
    var anx = 0;
    var folder_anx_temp = $('#carpeta_temporal').attr('value');
    var ruta_anx = urlj + 'inicio/guardar_gral/' + folder_anx_temp;
    new FUload('btnAnexo', ruta_anx, {
        start: function (file) {
            wait.start();
        },
        sucess: function (data) {
            wait.close();

            if ($.trim(data) !== "") {

                var a_exten = $.trim(data).split('.');

                var exten = "." + a_exten[(a_exten.length - 1)];
                // verifica existencia del mismo documento en la carpeta.
                var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                if (a_exten[(a_exten.length - 1)] === 'png' || a_exten[(a_exten.length - 1)] === 'jpg' || a_exten[(a_exten.length - 1)] === 'jpeg' || a_exten[(a_exten.length - 1)] === 'pdf') {
                    preview += "<td><a  title=\"Ver Anexo\" class='ver_en_modal fancybox-buttons' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                } else {
                    preview += "<td><a target='_blank' title=\"Ver Anexo\" class='' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                }

                preview += "<img id='pre" + anx + "' src='' width='88' height='88' class='imagen_documento'></a></td>";
                preview += "<td><input maxlength='75' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc[]' value='" + $.trim(data).replace(exten, '') + "'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc" + anx + "'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                //preview+="<td><input maxlength='50' readonly='readonly' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc"+i+"' value='"+$.trim(data).replace(exten,'')+"'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc"+i+"'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                preview += "<td style='vertical-align:middle !important; width:30px !important;'><img  style='display:none;' src='" + urlj + "media/editar_documento.png" + "' title='Editar' value='titulo_doc" + anx + "' class='editar_documento'/></td>";
                preview += "<td style='background:#E1E7F0!important;'><a href=\"javascript: void(0);\" title=\"Eliminar Anexo\" class='eliminar_imagen' id='delete" + anx + "' custom='' custom_id=''><img class='quitar_documento' src='" + urlj + "media/eliminar_documento.png" + "' title='Eliminar documento'></a></div>";
                preview += "<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></td></tr>";

                $("#previews").append(preview).show(300);
                $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");
                $("#preview" + anx).fadeIn(400);

                //document.getElementById('pre'+i).src=base+"media/imagenes/sistema/pdf.png";
                document.getElementById('pre' + anx).src = urlj + "media/imagenes/sistema/" + a_exten[(a_exten.length - 1)] + ".png";
                document.getElementById('ruta' + anx).value = $.trim(data);
                document.getElementById('delete' + anx).custom = $.trim(data);
                document.getElementById('delete' + anx).custom_id = i;
                valor = document.getElementById('pre' + anx).src;

                // $('input[name=titulo_doc'+i+']').focus();
                // nombre_doc=$('input[name=titulo_doc'+i+']').val();

                anx++;
                $(".eliminar_imagen, .verAnexo").tooltip();
            } else { //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();

        url = this.custom;
        id_key = this.custom_id;
        id = this.id;
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/' + folder_anx_temp,
            data: {url: url},
            success: function (data) {
                $("#ruta" + id_key).val("");
                $("#" + id).parent().parent().remove().delay(300);
            }
        });
    });

    $(".delete_anexo").live('click', function (event) {
        event.preventDefault();

        var anexo = $(this).data('anexo');

        var idAnexo = "#anexo_" + anexo;

        alerta_confirm_ajax(eliminarAnexo, idAnexo, 'Alerta de Confirmación', '¿Éstas seguro que quieres eliminar este registro?');
        //$("#anexo_" + anexo).remove().delay(500);
    });

    $(".verAnexo").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        helpers: {
            title: {
                type: 'inside'
            }
        }
    });

    $("#slcestado").change(function(){
        var estado = $(this).val();
        var estado_temp = $("#plaza_temp").val();
        var plaza_id = $("#plaza_id").val();
        console.log(estado);
        if($.trim(estado) != ''){
            if(estado_temp == 1){
                $(this).val(estado_temp);
                $("#slcestado").select2();
            } else{
                $("#plaza_temp").val(1);
            }
            if(estado == 2){
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'estructura_organizativa/procesos/verificar_plaza',
                    data: {plaza: plaza_id},
                    success: function (data) {
                        console.log(data);
                        if(data.empleado){
                            alerta_confirm_ajax(verificar_plaza,null,'Alerta','Esta plaza esta asociada a "'+data.nombre_empleado+'", ¿seguro que quiere desactivarla?');
                        } else{
                            $("#slcestado").val(2);
                            $("#slcestado").select2();
                            $("#plaza_temp").val(0);
                        }   
                    }
                });
            }
        } else{
            $("#plaza_temp").val(1);
            $("#slcestado").select2();
        }
    })
   
    $("#btn_finanzas").click(function () {
        event.preventDefault();
        var centro_costo        = $("#slc_centro_costo").val();
        var centro_costo_text   = $("#slc_centro_costo option:selected").text();
        var contar_porcentajes  = 0;
        var repetido            = false;

        var porcentaje      = $("#txt_porcentaje").val();

        if ( centro_costo == ""){
            crear_alerta('error', 'Finanzas', 'Favor agregue centro de costo');
            return false;
        }
        
        if ( porcentaje == "" || porcentaje <= 0 ){
            crear_alerta('error', 'Finanzas', 'Porcentaje debe se mayor a 0');
            $("#txt_porcentaje").focus();
            return false;
        }

        if ( porcentaje > 100 ){
            crear_alerta('error', 'Finanzas', 'Porcentaje debe se menor a 100');
            $("#txt_porcentaje").focus();
            return false;
        }

        contar_porcentajes = contar_porcentajes + parseFloat(porcentaje);

        if ($("#tbl_contenedor_finanzas .tr_finanzas").length > 0) {
            $("#tbl_contenedor_finanzas .tr_finanzas").each(function () {
        
                var id_centro = $(this).attr("id");
            
                if ( id_centro == (centro_costo) ) {
                    repetido = true;
                }

                contar_porcentajes = contar_porcentajes + parseFloat( $("#txt_porcentaje_finanza_"+id_centro).val() );
            });
        }
        
        if ( repetido == true){
            crear_alerta('error', 'Finanzas', 'Centro de costos ya fue agregado.');
            return false;
        }

        if ( contar_porcentajes > 100 ){
            crear_alerta('error', 'Finanzas', 'Porcentaje no debe ser mas de 100.');
            return false;
        }

        //Se dibuja el html
        var html = '<tr id="'+centro_costo+'" class="tr_finanzas">';
                html += '<td>';
                    html += centro_costo_text;
                    html += '<input type="hidden" id="txt_centro_costo_finanza_'+centro_costo+'" name="txt_centro_costo_finanza[]" class="text tables-input" value="' + centro_costo + '"/>';
                    html += '<input type="hidden" id="txt_centro_costo_new'+centro_costo+'" name="txt_centro_costo_new[]" class="text tables-input" value="1"/>';
                html += '</td>';
                html += '<td>';
                    html += porcentaje;
                    html += '<input type="hidden" id="txt_porcentaje_finanza_'+centro_costo+'" name="txt_porcentaje_finanza[]" class="text tables-input" value="' + porcentaje + '"/>';
                html += '</td>';
                html += '<td>';
                    html += '<button type="button" class="btn btn-danger btn-mini btn_del_finanzas" style="float:center;  height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
                html += '</td>';
            html += '</tr>';

        
        $("#tbl_contenedor_finanzas").append(html);

        html="<tr>";
            html +="<td>Total</td>";            
            html +="<td colspan='2'>"+contar_porcentajes+"%</td>";
        html +="</tr>";

        $("#tbl_foot_finanzas").html(html);


        $("#slc_centro_costo option:selected").removeAttr('selected');

        aplicarSelect2("#slc_centro_costo");
        $("#txt_porcentaje").val("");
           
    });

     //Eliminar finanza
     $(".btn_del_finanzas").live("click", function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);

        var contar_porcentajes = 0;
        
        if ($("#tbl_contenedor_finanzas .tr_finanzas").length > 0) {
            $("#tbl_contenedor_finanzas .tr_finanzas").each(function () {
        
                var id_centro = $(this).attr("id");

                contar_porcentajes = contar_porcentajes + parseFloat( $("#txt_porcentaje_finanza_"+id_centro).val() );
            });
        }
        
        if ( contar_porcentajes  > 0 ){
            html="<tr>";
                html +="<td>total</td>";            
                html +="<td colspan='2'>"+contar_porcentajes+"%</td>";
            html +="</tr>";

            $("#tbl_foot_finanzas").html(html);
        } else {
            $("#tbl_foot_finanzas").html("");
        }
        
    });

    //SUGERIR COMO NOMBRE DE PLAZA EL NOMBRE DEL PUESTO
    $("#slcPuesto").change(function(event) {
        /* Act on the event */
        if ($("#txtNombre").val().trim() == "") {
            $("#txtNombre").val($("#slcPuesto option:selected").text().trim());
        }
    });

    $("#slcArea").change(function () {
        if ($(this).val()>0) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'estructura_organizativa/procesos/ajax_prefiltro_dependencia',
                data: {areaDependencia: $(this).val()},
                success: function (data) {
                    console.log(data);
                    $("#slcDependencia").html(data);
                    $("#slcDependencia").select2();
                }
            });
        } else {
            var slct = '<option value=""></option>';
            var slctdrop = slct + $("#slc_plz_original").val();
            $("#slcDependencia").html(slctdrop);
            $("#slcDependencia").select2();
        }
    });

    $('#slcAreaDependencia').on('change', function(){
        if ($(this).val()>0) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'estructura_organizativa/procesos/ajax_prefiltro_dependencia',
                data: {areaDependencia: $(this).val()},
                success: function (data) {
                    $("#slcDependencia").html(data);
                }
            });
        } else {
            $("#slcDependencia").html('<option value=""></option>');
            $("#slcDependencia").select2();
        }
    });


/// peticiones ajax para filtra los selectores de area-nivel
$(".select_nivel_area").change(function(event) {
    var idnivel = $(this).data('id');
    var orden_nivel = $(this).data('orden');
    var id_area = $(this).val();
    var siguiente_elemento =  $(this).parent().parent().next().find('select:first');
    var id_siguiente_elemento = (siguiente_elemento)? $(siguiente_elemento).attr('id'):"";
    var id_nivel_siguiente = (siguiente_elemento)? $(siguiente_elemento).data('id'):0;

    if (idnivel > 0 && id_area > 0 && id_siguiente_elemento != "" && id_nivel_siguiente > 0) 
    {
           url_ajax = window.satelite.base_url('estructura_organizativa/procesos/cargar_area_nivel');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    idnivel: idnivel,
                    id_area: id_area,
                    id_nivel_siguiente:id_nivel_siguiente
                },
                beforeSend: function () {
                    wait.start();
                },
                error: function (xhr, status, error){
                 exportarError(xhr.responseText);
                 wait.close();
             },
             success: function (json) {
                    $("#"+id_siguiente_elemento).html(json.opciones);
                    $("#"+id_siguiente_elemento).select2();
                    wait.close();
                 
             }
         });
    }    
    $("#slcArea").val("");
    $( ".select_nivel_area").each(function( index, element ) {
      // element == this
      if ($(this).val() > 0 ) 
        {
            $("#slcArea").val($(this).val());
        };
    }); 

    if ($("#slcArea").val() > 0 ) { $("#slcArea_error").text(''); }

});

});

function verificar_plaza(){
    //console.log(plaza_id);
    $("#slcestado").val(2);
    $("#slcestado").select2();
    $("#plaza_temp").val(0);
}

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function cambiarTab(id_tab, tiempo) {
    //$("#pes-contactos").trigger("click");
    event.preventDefault();
    setTimeout(function () {
        $("#" + id_tab).trigger("click");
    }, tiempo);
}

function reestablecerAnexo() {
    $('#txtTituloAnexoDoc').val('');
    $("#txtTituloAnexoDoc").attr('readonly', 'readonly');
    $("#txtTituloAnexoDoc").removeAttr('style');
    $("#del_anexo").attr('href', '#');
    $("#link_anexo").attr('href', '#');
    $("#ruta_temporal").val('');
    $("#titulo_temporal").val('');
    $("#link_anexo, #del_anexo ").hide('slow');
    $("#btnAnexoDoc").show('slow');

}

function aplicarDatePicker(idCampo, destruir) {

    if (destruir) {
        $("#" + idCampo).datepicker('destroy');
    } else {
        $("#" + idCampo).datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
                    //minDate: 0
        });
    }
}

function verificarValidacion() {
    $("#pes-generales").removeClass("tab-error");
    $("#pes-logros").removeClass("tab-error");
    $("#pes-condiciones").removeClass("tab-error");
    $("#pes-horarios").removeClass("tab-error");
    $("#pes-anexos").removeClass("tab-error");
    var salir = 0;
    $("#mytab li>a").each(function (index) {
        var required = $(this).data('required');
        var tabId = $(this).attr('id');
        if (required === true) {
            //Se obtiene la regla
            var regla = $(this).data('rule');
            var liParent = $(this).parent();
            if (regla !== '') {
                switch (regla) {
                    case 'form':
                        var valid = $("#frm-proveedor").valid();
                        var validacion = $("#frm-proveedor").validate();

                        if (!valid) {
                            //primer elemento con error
                            var elemento = validacion.errorList[0].element;

                            var parentTab = $("#" + elemento.id).parents('.tab-pane');

                            var idTab = parentTab.attr('id');

                            if (salir == 0) {
                                salir = 1;
                                var tabElement = $("#mytab li a[href='#" + idTab + "']").attr('id');

                                activar_tab(tabElement, 'Campos Requeridos (*)', 'Favor revisar los campos requeridos en la ');
                            } else {
                                activar_tab(tabElement, 'Campos Requeridos (*)', 'Favor revisar los campos requeridos en la ', 1);
                            }

                            error_encontrado = true;
                        }
                        break;
                    case 'min_lenght':
                        var selectorContenido = $(this).data('selector');
                        var cantidadMinima = $(this).data('min');
                        var Tab

                        if ($(selectorContenido).length < cantidadMinima) {


                            if (salir == 0) {
                                activar_tab(tabId, 'Cantidad Mínima', 'Favor ingresar al menos ' + cantidadMinima + ' registro(s) en la ');
                                salir = 1;
                            } else {
                                activar_tab(tabId, 'Cantidad Mínima', 'Favor ingresar al menos ' + cantidadMinima + ' registro(s) en la ', 1);
                            }


                            //alert(tabId);
                            error_encontrado = true;
                        }

                        break;
                }
            }
        }

        //if (salir == 1) {
        // return false;
        //}


    });
    if (error_encontrado == true) {
        return false;
    }
    return true;
}

function activar_tab(tabElement, tituloError, Frase, soloEstilo) {


    if (soloEstilo != null) {
        $("#" + tabElement).addClass('tab-error');
    } else {
        //setTimeout(function () {
        //tabElement.addClass('tab-error');
        $("#" + tabElement).addClass('tab-error');
        $("#" + tabElement).trigger('click');
        //var tabText = $("#" + tabElement).text();

        //crear_alerta('error', tituloError, Frase + '<br/> <h4> Pestaña ' + tabText + '</h4>');
        //}, 500);
    }
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }

        opciones += this.outerHTML;
    });

    return opciones;
}

function aplicarSelect2(selector) {
    $(selector).select2({
        placeholder: 'Seleccione una opción'
    });
}


function eliminarAnexo(selectorElemento) {
    $(selectorElemento).remove().delay(500);
}


$('.boton_anterior_tab').click(function(event) {
    $("[href='#"+$(this).parent().prev().attr('id')+"']").trigger('click');
});
    
$('.boton_siguiente_tab').click(function(event) {
    $("[href='#"+$(this).parent().next().attr('id')+"']").trigger('click');
});
    
    
function verifica_edad() {
    var edadMin = parseInt($("#slcEdadMinima").val());
    var edadMax = parseInt($("#slcEdadMaxima").val());
    var max_prm = parseInt($("#max_age").val());
    var min_prm = parseInt($("#min_age").val());
    if (edadMin != "") {
        if (edadMin < min_prm) {
            crear_alerta('error', 'Rango de Edades', 'La edad mínima no puede ser menor a ' + min_prm);
            $("#slcEdadMinima").val("");
            return false;
        }
    }
    if (edadMax != "") {
        if (edadMax > max_prm) {
            crear_alerta('error', 'Rango de Edades', 'La edad máxima no puede ser mayor a ' + max_prm);
            $("#slcEdadMaxima").val("");
            return false;
        }
    }
    if (edadMin != "" && edadMax != "") {
        if (edadMin > edadMax) {
            crear_alerta('error', 'Rango de Edades', 'Verifique el rango de edades');
            return false;
        }
    }    
}