jQuery(document).ready(function ($) {
    $('select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    
    $("select").select2();

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true},
            'slcNivel': {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido",
            'slcNivel': "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                //$(element).next().append(error);
                error.insertAfter(element);
                //$("#error_fecha").html(error);
            }
            
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
          url_ajax = window.satelite.base_url('encuesta/reportes/filtrar_tabla_rastreo_indicadores');
          
           $.ajax({
               url: url_ajax,
               type: 'POST',
               dataType: 'json',
               data: $("#frmConsultaform").serialize(),
               beforeSend: function () {
                   wait.start();
               },
               error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                $("#contenedorTabla").html(json.html);
                wait.close();

            }
        });
       }
   });

    $("body").on("change", ".add_level", function (event) {
        event.preventDefault();
        var url_ajax = window.satelite.base_url('encuesta/reportes/get_clasificacion_hijo');
        $("select").select2("destroy");
        while ($(this).closest(".select_dynamic").next().length > 0) {
            $(this).closest(".select_dynamic").next().remove();
        }
        //console.log($(this).closest(".select_dynamic").next().length);
        $.ajax({
            url: url_ajax,
            type: 'POST',
            dataType: 'json',
            data: {
                id_padre: event.val
            },
            beforeSend: function () {
                wait.start();
            },
            error: function (xhr, status, error) {
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                if (json.length == 0) {
                    $("select").select2();
                    wait.close();
                    return false;
                }
                var option = '<option value="*">Todos los registros</option>';
                var select = '<select style="width:114%" name="slc_nivel[]"  required placeholder="Seleccione" class="nostyle add_level" >';
                json.forEach((element) => {
                    option += '<option value="' + element.cla_id + '"> ' + element.cla_nombre + ' </option>';
                });
                select += option;
                select += '</select>';

                var html = '<div class="span4 select_dynamic"> <div class="row-fluid" > <label class="form-label span4" for="normal">' + json[0].niv_nombre +'</label><div class="span8">' + select + '</div></div ></div >';
                $(".dynamic_select").append(html);
                $("select").select2();
                wait.close();
            }
        });

    });



});


