jQuery(document).ready(function ($) {
    $('select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function (event) {
        validar_fecha_inicio_fin('txtFecha_desde', 'txtFecha_hasta', 'La fecha de desde debe ser menor a la fecha hasta');
    });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true},
            slcSucursal: {required: true},
            slcEncuesta: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido",
            slcSucursal: "Campo requerido",
            slcEncuesta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            } else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
            url_ajax = window.satelite.base_url('encuesta/reportes/filtrar_descarga_informacion');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    txtFecha_desde: $("#txtFecha_desde").val(),
                    txtFecha_hasta: $("#txtFecha_hasta").val(),
                    slcAgencia: $("#slcSucursal").val(),
                    slcEncuesta: $("#slcEncuesta").val()
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (json) {
                    console.log(json);
                    $("#contenedorTabla").html(json.html);
                    $("#exportar").show();
                    wait.close();
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                    // exportarError(xhr.responseText);
                    wait.close();
                }
            });
        }
    });

    $("#slcSucursal").change(function (event) {
        /* Act on the event */
        event.preventDefault();
        limpiar_select('Cargando...');
        if ($(this).val() > 0) {
            id = $(this).val();
            url_ajax = window.satelite.base_url('encuesta/reportes/filtrar_encuesta_sucursal');

            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    id_sucursal: id
                },
                beforeSend: function () {
                    wait.start('Cargando encuestas ..');
                },
                error: function (xhr, status, error) {
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#slcEncuesta").html(json.html_option);
                    $("#slcEncuesta").attr('placeholder', 'Seleccione');
                    $("#slcEncuesta").select2();
                    wait.close();

                }
            });
        } else {
            limpiar_select('Seleccione');
        }
    });
    $('body').on('click','.view_anexo', function(e) {
        e.preventDefault();
        url_carga = $(this).attr('href');
        windowAnexo({url: url_carga, title: 'Anexo', w: 900, h: 500}); 
        //window.open(url_carga, "_blank", "toolbar=yes,scrollbars=yes,resizable=yes,top=100,left=250,width=1200,height=500");
    });

});

function limpiar_select(placeholder_select) {
    $("#slcEncuesta").html('<option value=""></option>');
    $("#slcEncuesta").attr('placeholder', placeholder_select);
    $("#slcEncuesta").select2();
}

const windowAnexo = ({url, title, w, h}) => {
    // Fixes dual-screen position                             Most browsers      Firefox
    const dualScreenLeft = window.screenLeft !==  undefined ? window.screenLeft : window.screenX;
    const dualScreenTop = window.screenTop !==  undefined   ? window.screenTop  : window.screenY;

    const width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    const height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

    const systemZoom = width / window.screen.availWidth;
    const left = (width - w) / 2 / systemZoom + dualScreenLeft
    const top = (height - h) / 2 / systemZoom + dualScreenTop
    const newWindow = window.open(url, title, 
      `
      scrollbars=yes,
      width=${w / systemZoom}, 
      height=${h / systemZoom}, 
      top=${top}, 
      left=${left}
      `
    )

    if (window.focus) newWindow.focus();
}
