jQuery(document).ready(function ($) {
    $('select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function (event) {
        validar_fecha_inicio_fin('txtFecha_desde', 'txtFecha_hasta', 'La fecha de desde debe ser menor a la fecha hasta');
    });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true},
            slcSucursal: {required: true},
            slcEncuesta: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido",
            slcSucursal: "Campo requerido",
            slcEncuesta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            } else
            {
                //$(element).next().append(error);
                error.insertAfter(element);
                //$("#error_fecha").html(error);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
            url_ajax = window.satelite.base_url('encuesta/reportes/filtrar_respuestaEncuesta');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    txtFecha_desde: $("#txtFecha_desde").val(),
                    txtFecha_hasta: $("#txtFecha_hasta").val(),
                    slcAgencia: $("#slcSucursal").val(),
                    slcEncuesta: $("#slcEncuesta").val()
                },
                beforeSend: function () {
                    wait.start();
                },
                error: function (xhr, status, error) {
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#contenedorTabla").html(json.html);
                    setTimeout(function () {
                        $('.ver_respuesta').tooltip();
                    }, 500);
                    wait.close();
                }
            });
        }
    });

    $("#slcSucursal").change(function (event) {
        /* Act on the event */
        event.preventDefault();
        limpiar_select('Cargando...');
        if ($(this).val() > 0) {
            id = $(this).val();
            url_ajax = window.satelite.base_url('encuesta/reportes/filtrar_encuesta_sucursal');

            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    id_sucursal: id
                },
                beforeSend: function () {
                    wait.start('Cargando encuestas ..');
                },
                error: function (xhr, status, error) {
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#slcEncuesta").html(json.html_option);
                    $("#slcEncuesta").attr('placeholder', 'Seleccione');
                    $("#slcEncuesta").select2();
                    wait.close();

                }
            });
        } else {
            limpiar_select('Seleccione');
        }
    });

    $("body").on("click", ".preg_tipo_12y11", function (event) {
        event.preventDefault();
        var url_codigo = $(this).attr("href");
        console.log(url_codigo);
        var html = '<img width="500px" height="500px" src="' + url_codigo + '">';

        var ultimo_registro = url_codigo.split("/").pop();
        if ((ultimo_registro.split(".").pop() == 'png') || (ultimo_registro.split(".").pop() == 'jpg')) {
            $.fancybox(html);
        } else if ((ultimo_registro.split(".").pop() == 'pdf')) {
            $.fancybox({
                'href': url_codigo,
                type: 'iframe',
                width: '100%',
                height: '100%',
                closeBtn: true,
            });
            setTimeout(() => {
                $(".fancybox-inner").css("height","900px");
            }, 2000);
        } else {
            window.open(url_codigo, "_blankl")
        }
        //console.log(url_codigo.split("/").pop())


    });


});

function limpiar_select(placeholder_select) {
    $("#slcEncuesta").html('<option value=""></option>');
    $("#slcEncuesta").attr('placeholder', placeholder_select);
    $("#slcEncuesta").select2();
}

