jQuery(document).ready(function ($) {
    $('select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                //$(element).next().append(error);
                error.insertAfter(element);
                //$("#error_fecha").html(error);
            }
            
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
          url_ajax = window.satelite.base_url('encuesta/reportes/filtrar_consulta_encuesta_sucursal');
          
           $.ajax({
               url: url_ajax,
               type: 'POST',
               dataType: 'json',
               data: {
                   txtFecha_desde: $("#txtFecha_desde").val(),
                   txtFecha_hasta: $("#txtFecha_hasta").val(),
                   slcAgencia: $("#slcSucursal").val()
               },
               beforeSend: function () {
                   wait.start();
               },
               error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                $("#contenedorTabla").html(json.html);
                wait.close();

            }
        });
       }
   });
    



});


